/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.billing.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserLicenseDescriptor;
import org.eclipse.passage.loc.internal.billing.core.ProductVersionLicense;

public final class UserLicenses {
    private final List<UserDescriptor> users;

    public UserLicenses(List<UserDescriptor> users) {
        this.users = users;
    }

    public final List<UserLicenseDescriptor> getAllLicenses() {
        Predicate<UserLicenseDescriptor> any = new Predicate<UserLicenseDescriptor>(){

            @Override
            public boolean test(UserLicenseDescriptor t) {
                return true;
            }
        };
        return this.getLicenses(any);
    }

    public final List<UserLicenseDescriptor> getLicensesForProduct(final String productIdentifier) {
        Predicate<UserLicenseDescriptor> product = new Predicate<UserLicenseDescriptor>(){

            @Override
            public boolean test(UserLicenseDescriptor descriptor) {
                return descriptor.getProductIdentifier().equals(productIdentifier);
            }
        };
        return this.getLicenses(product);
    }

    public final List<UserLicenseDescriptor> getLicensesForProductVersion(final String productIdentifier, final String versionIdentifier) {
        Predicate<UserLicenseDescriptor> productAndVersion = new Predicate<UserLicenseDescriptor>(){

            @Override
            public boolean test(UserLicenseDescriptor descriptor) {
                return descriptor.getProductIdentifier().equals(productIdentifier) && descriptor.getProductVersion().equals(versionIdentifier);
            }
        };
        return this.getLicenses(productAndVersion);
    }

    private final List<UserLicenseDescriptor> getLicenses(Predicate<UserLicenseDescriptor> condition) {
        return this.users.stream().map(UserDescriptor::getUserLicenses).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false)).filter(condition).collect(Collectors.toList());
    }

    public final Map<ProductVersionLicense, Integer> getLicensesNumbers() {
        List licenses = this.getAllLicenses().stream().map(ProductVersionLicense::new).collect(Collectors.toList());
        return licenses.stream().collect(Collectors.toMap(license -> license, license -> Collections.frequency(licenses, license), (l1, l2) -> l1));
    }
}

