/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication.oauth;

import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.token.OAuthToken;
import org.eclipse.orion.server.authentication.oauth.OAuthException;

public abstract class OAuthConsumer
implements OAuthToken {
    protected OAuthToken accessToken;
    private final String redirect;

    public OAuthConsumer(OAuthAccessTokenResponse oauthAccessTokenResponse, String redirect) {
        this.redirect = redirect;
        this.accessToken = oauthAccessTokenResponse.getOAuthToken();
    }

    public String getRedirect() {
        return this.redirect;
    }

    public String getAccessToken() {
        return this.accessToken.getAccessToken();
    }

    public Long getExpiresIn() {
        return this.accessToken.getExpiresIn();
    }

    public String getRefreshToken() {
        return this.accessToken.getRefreshToken();
    }

    public String getScope() {
        return this.accessToken.getScope();
    }

    protected String getServerResponse(String url) throws OAuthException {
        OAuthResourceResponse response;
        OAuthClientRequest request;
        OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        try {
            request = new OAuthBearerClientRequest(url).setAccessToken(this.getAccessToken()).buildQueryMessage();
        }
        catch (OAuthSystemException oAuthSystemException) {
            throw new OAuthException("An error occured while authenticating the user");
        }
        try {
            response = (OAuthResourceResponse)oAuthClient.resource(request, "GET", OAuthResourceResponse.class);
        }
        catch (OAuthProblemException oAuthProblemException) {
            throw new OAuthException("An error occured while authenticating the user");
        }
        catch (OAuthSystemException oAuthSystemException) {
            throw new OAuthException("An error occured while authenticating the user");
        }
        return response.getBody();
    }

    public abstract String getIdentifier();

    public abstract String getEmail();

    public abstract String getUsername();

    public abstract boolean isEmailVerifiecd();

    public String getOpenidIdentifier() {
        return null;
    }
}

