/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.accesslog;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.accesslog.AccessLogFormat;
import org.glassfish.grizzly.http.server.accesslog.SimpleDateFormatThreadLocal;
import org.glassfish.grizzly.http.util.MimeHeaders;

public class ApacheLogFormat
implements AccessLogFormat {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final String COMMON_FORMAT = "%h - %u %t \"%r\" %s %b";
    public static final String COMBINED_FORMAT = "%h - %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"";
    public static final String VHOST_COMMON_FORMAT = "%v %h - %u %t \"%r\" %s %b";
    public static final String VHOST_COMBINED_FORMAT = "%v %h - %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"";
    public static final String REFERER_FORMAT = "%{Referer}i -> %U";
    public static final String AGENT_FORMAT = "%{User-agent}i";
    public static final ApacheLogFormat COMMON = new ApacheLogFormat("%h - %u %t \"%r\" %s %b");
    public static final ApacheLogFormat COMBINED = new ApacheLogFormat("%h - %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"");
    public static final ApacheLogFormat VHOST_COMMON = new ApacheLogFormat("%v %h - %u %t \"%r\" %s %b");
    public static final ApacheLogFormat VHOST_COMBINED = new ApacheLogFormat("%v %h - %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"");
    public static final ApacheLogFormat REFERER = new ApacheLogFormat("%{Referer}i -> %U");
    public static final ApacheLogFormat AGENT = new ApacheLogFormat("%{User-agent}i");
    public static final ApacheLogFormat COMMON_UTC = new ApacheLogFormat(UTC, "%h - %u %t \"%r\" %s %b");
    public static final ApacheLogFormat COMBINED_UTC = new ApacheLogFormat(UTC, "%h - %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"");
    public static final ApacheLogFormat VHOST_COMMON_UTC = new ApacheLogFormat(UTC, "%v %h - %u %t \"%r\" %s %b");
    public static final ApacheLogFormat VHOST_COMBINED_UTC = new ApacheLogFormat(UTC, "%v %h - %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"");
    public static final ApacheLogFormat REFERER_UTC = new ApacheLogFormat(UTC, "%{Referer}i -> %U");
    public static final ApacheLogFormat AGENT_UTC = new ApacheLogFormat(UTC, "%{User-agent}i");
    private static final Logger LOGGER = Grizzly.logger(HttpServer.class);
    private final List<Field> fields;
    private final TimeZone timeZone;

    public ApacheLogFormat(String format) {
        this(TimeZone.getDefault(), format);
    }

    public ApacheLogFormat(TimeZone timeZone, String format) {
        if (timeZone == null) {
            throw new NullPointerException("Null time zone");
        }
        this.fields = new ArrayList<Field>();
        this.timeZone = timeZone;
        this.parse(format);
    }

    @Override
    public String format(Response response, Date timeStamp, long responseNanos) {
        StringBuilder builder = new StringBuilder();
        Request request = response.getRequest();
        for (Field field : this.fields) {
            try {
                field.format(builder, request, response, timeStamp, responseNanos);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception formatting access log entry", exception);
                builder.append('-');
            }
        }
        return builder.toString();
    }

    String unsafeFormat(Response response, Date timeStamp, long responseNanos) {
        StringBuilder builder = new StringBuilder();
        Request request = response.getRequest();
        for (Field field : this.fields) {
            field.format(builder, request, response, timeStamp, responseNanos);
        }
        return builder.toString();
    }

    public String getFormat() {
        StringBuilder builder = new StringBuilder();
        for (Field field : this.fields) {
            builder.append(field.toString());
        }
        return builder.toString();
    }

    private void parse(String format) {
        block4: for (int x = 0; x < format.length(); ++x) {
            switch (format.charAt(x)) {
                case '\\': {
                    x = this.parseEscape(format, x);
                    continue block4;
                }
                case '%': {
                    x = this.parseFormat(format, null, x);
                    continue block4;
                }
                default: {
                    this.addLiteral(format.charAt(x));
                }
            }
        }
    }

    private int parseFormat(String format, String parameter, int position) {
        if (++position < format.length()) {
            char field = format.charAt(position);
            if (parameter != null) {
                switch (field) {
                    case 'C': {
                        break;
                    }
                    case 'h': {
                        break;
                    }
                    case 'i': {
                        break;
                    }
                    case 'o': {
                        break;
                    }
                    case 'p': {
                        break;
                    }
                    case 't': {
                        break;
                    }
                    case 'T': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported parameter \"" + parameter + "\" for field '" + field + "' in [" + format + "] at character " + position);
                    }
                }
            }
            switch (field) {
                case '{': {
                    return this.parseParameter(format, position);
                }
                case '%': {
                    this.addLiteral('%');
                    break;
                }
                case 'a': {
                    this.fields.add(new RemoteAddressField());
                    break;
                }
                case 'A': {
                    this.fields.add(new LocalAddressField());
                    break;
                }
                case 'b': {
                    this.fields.add(new ResponseSizeField(false));
                    break;
                }
                case 'B': {
                    this.fields.add(new ResponseSizeField(true));
                    break;
                }
                case 'C': {
                    this.fields.add(new RequestCookieField(parameter));
                    break;
                }
                case 'D': {
                    this.fields.add(new ResponseTimeField("micro", format, position));
                    break;
                }
                case 'h': {
                    this.fields.add(this.parseLocal(parameter, false, field, format, position) ? new LocalHostField() : new RemoteHostField());
                    break;
                }
                case 'H': {
                    this.fields.add(new RequestProtocolField());
                    break;
                }
                case 'i': {
                    this.fields.add(new RequestHeaderField(parameter));
                    break;
                }
                case 'm': {
                    this.fields.add(new RequestMethodField());
                    break;
                }
                case 'o': {
                    this.fields.add(new ResponseHeaderField(parameter));
                    break;
                }
                case 'p': {
                    this.fields.add(this.parseLocal(parameter, true, field, format, position) ? new LocalPortField() : new RemotePortField());
                    break;
                }
                case 'q': {
                    this.fields.add(new RequestQueryField());
                    break;
                }
                case 'r': {
                    this.fields.add(new RequestMethodField());
                    this.addLiteral(' ');
                    this.fields.add(new RequestURIField());
                    this.fields.add(new RequestQueryField());
                    this.addLiteral(' ');
                    this.fields.add(new RequestProtocolField());
                    break;
                }
                case 's': {
                    this.fields.add(new ResponseStatusField());
                    break;
                }
                case 't': {
                    this.fields.add(new RequestTimeField(parameter, this.timeZone));
                    break;
                }
                case 'T': {
                    this.fields.add(new ResponseTimeField(parameter, format, position));
                    break;
                }
                case 'u': {
                    this.fields.add(new RequestUserField());
                    break;
                }
                case 'U': {
                    this.fields.add(new RequestURIField());
                    break;
                }
                case 'v': {
                    this.fields.add(new ServerNameField());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported field '" + field + "' in [" + format + "] at character " + position);
                }
            }
            return position;
        }
        throw new IllegalArgumentException("Unterminated field declaration in [" + format + "] at character " + position);
    }

    private boolean parseLocal(String parameter, boolean defaultValue, char field, String format, int position) {
        if (parameter == null) {
            return defaultValue;
        }
        String p = parameter.trim().toLowerCase();
        if (p.equals("local")) {
            return true;
        }
        if (p.equals("remote")) {
            return false;
        }
        throw new IllegalArgumentException("Unsupported parameter \"" + parameter + "\" for field '" + field + "' in [" + format + "] at character " + position);
    }

    private int parseParameter(String format, int position) {
        if (++position < format.length()) {
            int end = format.indexOf(125, position);
            if (end == position) {
                return this.parseFormat(format, null, end);
            }
            if (end > position) {
                return this.parseFormat(format, format.substring(position, end), end);
            }
        }
        throw new IllegalArgumentException("Unterminated format parameter in [" + format + "] at character " + position);
    }

    private int parseEscape(String format, int position) {
        if (++position < format.length()) {
            char escaped = format.charAt(position);
            switch (escaped) {
                case 't': {
                    this.addLiteral('\t');
                    break;
                }
                case 'b': {
                    this.addLiteral('\b');
                    break;
                }
                case 'n': {
                    this.addLiteral('\n');
                    break;
                }
                case 'r': {
                    this.addLiteral('\r');
                    break;
                }
                case 'f': {
                    this.addLiteral('\f');
                    break;
                }
                default: {
                    this.addLiteral(escaped);
                }
            }
            return position;
        }
        throw new IllegalArgumentException("Unterminated escape sequence in [" + format + "] at character " + position);
    }

    private void addLiteral(char c) {
        Field last;
        if (!this.fields.isEmpty() && (last = this.fields.get(this.fields.size() - 1)) instanceof LiteralField) {
            ((LiteralField)last).append(c);
            return;
        }
        this.fields.add(new LiteralField(c));
    }

    private static abstract class Field {
        private Field() {
        }

        abstract StringBuilder format(StringBuilder var1, Request var2, Response var3, Date var4, long var5);

        public abstract String toString();
    }

    private static class RemoteAddressField
    extends AbstractField {
        RemoteAddressField() {
            super('a');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            String address = request.getRemoteAddr();
            return builder.append(address == null ? "-" : address);
        }
    }

    private static class LocalAddressField
    extends AbstractField {
        LocalAddressField() {
            super('A');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            String address = request.getLocalAddr();
            return builder.append(address == null ? "-" : address);
        }
    }

    private static class ResponseSizeField
    extends AbstractField {
        final String zero;

        ResponseSizeField(boolean zero) {
            super(zero ? (char)'B' : 'b');
            this.zero = zero ? "0" : "-";
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            long size = response.getContentLengthLong();
            return builder.append(size < 1L ? this.zero : Long.toString(size));
        }
    }

    private static class RequestCookieField
    extends AbstractField {
        final String name;

        RequestCookieField(String name) {
            super('C', name.trim().toLowerCase());
            this.name = name.trim().toLowerCase();
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!this.name.equals(cookie.getName().toLowerCase())) continue;
                    return builder.append(cookie.getValue());
                }
            }
            return builder;
        }
    }

    private static class ResponseTimeField
    extends Field {
        private final long scale;

        ResponseTimeField(String unit, String format, int position) {
            if (unit == null) {
                this.scale = 1000000000L;
                return;
            }
            String s = unit.trim().toLowerCase();
            if (s.equals("n") || s.equals("nano") || s.equals("nanos") || s.equals("nanosec") || s.equals("nanosecs") || s.equals("nanosecond") || s.equals("nanoseconds")) {
                this.scale = 1L;
            } else if (s.equals("micro") || s.equals("micros") || s.equals("microsec") || s.equals("microsecs") || s.equals("microsecond") || s.equals("microseconds")) {
                this.scale = 1000L;
            } else if (s.equals("m") || s.equals("milli") || s.equals("millis") || s.equals("millisec") || s.equals("millisecs") || s.equals("millisecond") || s.equals("milliseconds")) {
                this.scale = 1000000L;
            } else if (s.equals("s") || s.equals("sec") || s.equals("secs") || s.equals("second") || s.equals("seconds")) {
                this.scale = 1000000000L;
            } else {
                throw new IllegalArgumentException("Unsupported time unit \"" + unit + "\" for field 'T' in [" + format + "] at character " + position);
            }
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            if (responseNanos < 0L) {
                return builder.append('-');
            }
            return builder.append(responseNanos / this.scale);
        }

        @Override
        public String toString() {
            StringBuilder string = new StringBuilder().append('%');
            if (this.scale == 1L) {
                string.append("{n}T");
            } else if (this.scale == 1000L) {
                string.append('D');
            } else if (this.scale == 1000000L) {
                string.append("{m}T");
            } else if (this.scale == 1000000000L) {
                string.append('T');
            } else {
                string.append('{').append(this.scale).append("}T");
            }
            return string.toString();
        }
    }

    private static class LocalHostField
    extends AbstractField {
        LocalHostField() {
            super('h', "local");
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            String host = request.getLocalName();
            return builder.append(host == null ? "-" : host);
        }
    }

    private static class RemoteHostField
    extends AbstractField {
        RemoteHostField() {
            super('h');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            String host = request.getRemoteHost();
            return builder.append(host == null ? "-" : host);
        }
    }

    private static class RequestProtocolField
    extends AbstractField {
        RequestProtocolField() {
            super('H');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            Protocol protocol = request.getProtocol();
            if (protocol == null) {
                return builder.append("-");
            }
            switch (protocol) {
                case HTTP_0_9: {
                    return builder.append("HTTP/0.9");
                }
                case HTTP_1_0: {
                    return builder.append("HTTP/1.0");
                }
                case HTTP_1_1: {
                    return builder.append("HTTP/1.1");
                }
            }
            return builder.append("-");
        }
    }

    private static class RequestHeaderField
    extends HeaderField {
        RequestHeaderField(String name) {
            super('i', name);
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            return this.format(builder, request.getRequest().getHeaders());
        }
    }

    private static class RequestMethodField
    extends AbstractField {
        RequestMethodField() {
            super('m');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            Method method = request.getMethod();
            return builder.append(method == null ? "-" : method.toString());
        }
    }

    private static class ResponseHeaderField
    extends HeaderField {
        ResponseHeaderField(String name) {
            super('o', name);
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            return this.format(builder, response.getResponse().getHeaders());
        }
    }

    private static class LocalPortField
    extends AbstractField {
        LocalPortField() {
            super('p');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            int port = request.getLocalPort();
            return builder.append(port < 1 ? "-" : Integer.valueOf(port));
        }
    }

    private static class RemotePortField
    extends AbstractField {
        RemotePortField() {
            super('p', "remote");
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            int port = request.getRemotePort();
            return builder.append(port < 1 ? "-" : Integer.valueOf(port));
        }
    }

    private static class RequestQueryField
    extends AbstractField {
        RequestQueryField() {
            super('q');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            String query = request.getQueryString();
            if (query != null) {
                builder.append('?').append(query);
            }
            return builder;
        }
    }

    private static class RequestURIField
    extends AbstractField {
        RequestURIField() {
            super('U');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            String uri = request.getRequestURI();
            return builder.append(uri == null ? "-" : uri);
        }
    }

    private static class ResponseStatusField
    extends AbstractField {
        ResponseStatusField() {
            super('s');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            int status = response.getStatus();
            if (status < 10) {
                builder.append('0');
            }
            if (status < 100) {
                builder.append('0');
            }
            return builder.append(status);
        }
    }

    private static class RequestTimeField
    extends Field {
        private static final String DEFAULT_PATTERN = "[yyyy/MMM/dd:HH:mm:ss Z]";
        private final SimpleDateFormatThreadLocal simpleDateFormat;
        private final TimeZone timeZone;
        private final String pattern;
        private final String format;

        RequestTimeField(String format, TimeZone zone) {
            this.format = format;
            if (format == null) {
                this.pattern = DEFAULT_PATTERN;
                this.timeZone = zone;
            } else {
                int pos = format.lastIndexOf(64);
                if (pos < 0 || pos > 0 && format.charAt(pos - 1) == '@') {
                    this.pattern = format.replace("@@", "@");
                    this.timeZone = zone;
                } else if (pos == 0) {
                    this.pattern = DEFAULT_PATTERN;
                    this.timeZone = TimeZone.getTimeZone(format.substring(1));
                } else {
                    this.pattern = format.substring(0, pos).replace("@@", "@");
                    this.timeZone = TimeZone.getTimeZone(format.substring(pos + 1));
                }
            }
            this.simpleDateFormat = new SimpleDateFormatThreadLocal(this.pattern);
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            if (timeStamp == null) {
                return builder.append('-');
            }
            SimpleDateFormat format = (SimpleDateFormat)this.simpleDateFormat.get();
            format.setTimeZone(this.timeZone);
            return builder.append(format.format(timeStamp));
        }

        @Override
        public String toString() {
            return this.format == null ? "%t" : "%{" + this.format + "}t";
        }
    }

    private static class RequestUserField
    extends AbstractField {
        RequestUserField() {
            super('u');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            String user = request.getRemoteUser();
            return builder.append(user == null ? "-" : user);
        }
    }

    private static class ServerNameField
    extends AbstractField {
        ServerNameField() {
            super('v');
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            String name = request.getServerName();
            return builder.append(name == null ? "-" : name);
        }
    }

    private static class LiteralField
    extends Field {
        final StringBuilder contents;

        LiteralField(char character) {
            this.contents = new StringBuilder().append(character);
        }

        void append(char character) {
            this.contents.append(character);
        }

        @Override
        StringBuilder format(StringBuilder builder, Request request, Response response, Date timeStamp, long responseNanos) {
            return builder.append((CharSequence)this.contents);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int x = 0; x < this.contents.length(); ++x) {
                char character = this.contents.charAt(x);
                switch (character) {
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        builder.append('\\');
                        break;
                    }
                    case '%': {
                        builder.append('%');
                    }
                }
                builder.append(character);
            }
            return builder.toString();
        }
    }

    private static abstract class HeaderField
    extends AbstractField {
        final String name;

        HeaderField(char format, String name) {
            super(format, name.trim().toLowerCase());
            this.name = name.trim().toLowerCase();
        }

        StringBuilder format(StringBuilder builder, MimeHeaders headers) {
            Iterator<String> iterator = headers.values(this.name).iterator();
            if (iterator.hasNext()) {
                builder.append(iterator.next());
            }
            while (iterator.hasNext()) {
                builder.append("; ").append(iterator.next());
            }
            return builder;
        }
    }

    private static abstract class AbstractField
    extends Field {
        private final char format;
        private final String parameter;

        protected AbstractField(char format) {
            this(format, null);
        }

        protected AbstractField(char format, String parameter) {
            this.format = format;
            this.parameter = parameter;
        }

        @Override
        public final String toString() {
            StringBuilder builder = new StringBuilder().append('%');
            if (this.parameter != null) {
                builder.append('{').append(this.parameter).append('}');
            }
            return builder.append(this.format).toString();
        }
    }
}

