/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.GenericDAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MySQLBrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MySQLMessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class MySQLDAOFactory
extends GenericDAOFactory {
    private static final boolean enableStoredProc = Globals.getConfig().getBooleanProperty("imq.persist.jdbc.mysql.enableStoredProc", false);

    @Override
    public MessageDAO getMessageDAO() throws BrokerException {
        if (!enableStoredProc) {
            return super.getMessageDAO();
        }
        if (this.messageDAO == null) {
            this.messageDAO = new MySQLMessageDAOImpl();
        }
        return this.messageDAO;
    }

    @Override
    public BrokerDAO getBrokerDAO() throws BrokerException {
        if (!enableStoredProc) {
            return super.getBrokerDAO();
        }
        if (this.brokerDAO == null) {
            this.brokerDAO = new MySQLBrokerDAOImpl();
        }
        return this.brokerDAO;
    }
}

