/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public abstract class InspectorPanel
extends JPanel {
    private static final long serialVersionUID = 4745130922013473276L;
    private EventListenerList aListeners = null;
    private ConsoleObj conObj = null;

    protected InspectorPanel() {
        this.initContent();
    }

    public void fireAdminEventDispatched(AdminEvent ae) {
        if (this.aListeners == null) {
            return;
        }
        Object[] l = this.aListeners.getListenerList();
        for (int i = l.length - 2; i >= 0; i -= 2) {
            if (l[i] != AdminEventListener.class) continue;
            ((AdminEventListener)l[i + 1]).adminEventDispatched(ae);
        }
    }

    public void inspectConsoleObj(ConsoleObj conObj, EventListenerList l) {
        this.setConsoleObj(conObj);
        this.setAdminEventListener(l);
        this.inspectorInit();
    }

    public ConsoleObj getConsoleObj() {
        return this.conObj;
    }

    public void refresh() {
        if (this.conObj == null) {
            return;
        }
        this.inspectorInit();
    }

    private void initContent() {
        this.setLayout(new BorderLayout());
        JPanel workPanel = this.createWorkPanel();
        if (workPanel != null) {
            this.add((Component)workPanel, "Center");
        }
    }

    private void setConsoleObj(ConsoleObj conObj) {
        this.conObj = conObj;
    }

    private void setAdminEventListener(EventListenerList l) {
        this.aListeners = l;
    }

    public abstract JPanel createWorkPanel();

    public abstract void inspectorInit();

    public abstract void clearSelection();

    public abstract void selectedObjectUpdated();
}

