/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.DatagramChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.quic.client.ClientQuicConnection;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.quiche.PemExporter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicClientConnectorConfigurator
extends ClientConnector.Configurator {
    private static final Logger LOG = LoggerFactory.getLogger(QuicClientConnectorConfigurator.class);
    static final String PRIVATE_KEY_PEM_PATH_KEY = QuicClientConnectorConfigurator.class.getName() + ".privateKeyPemPath";
    static final String CERTIFICATE_CHAIN_PEM_PATH_KEY = QuicClientConnectorConfigurator.class.getName() + ".certificateChainPemPath";
    static final String TRUSTED_CERTIFICATES_PEM_PATH_KEY = QuicClientConnectorConfigurator.class.getName() + ".trustedCertificatesPemPath";
    private final QuicConfiguration configuration = new QuicConfiguration();
    private final UnaryOperator<Connection> configurator;
    private Path privateKeyPemPath;
    private Path certificateChainPemPath;
    private Path trustedCertificatesPemPath;

    public QuicClientConnectorConfigurator() {
        this(UnaryOperator.identity());
    }

    public QuicClientConnectorConfigurator(UnaryOperator<Connection> configurator) {
        this.configurator = Objects.requireNonNull(configurator);
        this.configuration.setSessionRecvWindow(0x1000000);
        this.configuration.setBidirectionalStreamRecvWindow(0x800000);
        this.configuration.setDisableActiveMigration(true);
    }

    public QuicConfiguration getQuicConfiguration() {
        return this.configuration;
    }

    protected void doStart() throws Exception {
        String certAlias;
        Path pemWorkDirectory = this.configuration.getPemWorkDirectory();
        ClientConnector clientConnector = (ClientConnector)this.getBean(ClientConnector.class);
        SslContextFactory.Client sslContextFactory = clientConnector.getSslContextFactory();
        KeyStore trustStore = sslContextFactory.getTrustStore();
        if (trustStore != null) {
            this.trustedCertificatesPemPath = PemExporter.exportTrustStore((KeyStore)trustStore, (Path)(pemWorkDirectory != null ? pemWorkDirectory : Path.of(System.getProperty("java.io.tmpdir"), new String[0])));
            this.configuration.getImplementationConfiguration().put(TRUSTED_CERTIFICATES_PEM_PATH_KEY, this.trustedCertificatesPemPath.toString());
        }
        if ((certAlias = sslContextFactory.getCertAlias()) != null) {
            if (pemWorkDirectory == null) {
                throw new IllegalStateException("No PEM work directory configured");
            }
            KeyStore keyStore = sslContextFactory.getKeyStore();
            String keyManagerPassword = sslContextFactory.getKeyManagerPassword();
            char[] password = keyManagerPassword == null ? sslContextFactory.getKeyStorePassword().toCharArray() : keyManagerPassword.toCharArray();
            Path[] keyPair = PemExporter.exportKeyPair((KeyStore)keyStore, (String)certAlias, (char[])password, (Path)pemWorkDirectory);
            this.privateKeyPemPath = keyPair[0];
            this.certificateChainPemPath = keyPair[1];
            this.configuration.getImplementationConfiguration().put(PRIVATE_KEY_PEM_PATH_KEY, this.privateKeyPemPath.toString());
            this.configuration.getImplementationConfiguration().put(CERTIFICATE_CHAIN_PEM_PATH_KEY, this.certificateChainPemPath.toString());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.deleteFile(this.privateKeyPemPath);
        this.privateKeyPemPath = null;
        this.configuration.getImplementationConfiguration().remove(PRIVATE_KEY_PEM_PATH_KEY);
        this.deleteFile(this.certificateChainPemPath);
        this.certificateChainPemPath = null;
        this.configuration.getImplementationConfiguration().remove(CERTIFICATE_CHAIN_PEM_PATH_KEY);
        this.deleteFile(this.trustedCertificatesPemPath);
        this.trustedCertificatesPemPath = null;
        this.configuration.getImplementationConfiguration().remove(TRUSTED_CERTIFICATES_PEM_PATH_KEY);
    }

    private void deleteFile(Path file) {
        block3: {
            try {
                if (file != null) {
                    Files.delete(file);
                }
            }
            catch (IOException x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("could not delete {}", (Object)file, (Object)x);
            }
        }
    }

    public boolean isIntrinsicallySecure(ClientConnector clientConnector, SocketAddress address) {
        return true;
    }

    public ClientConnector.Configurator.ChannelWithAddress newChannelWithAddress(ClientConnector clientConnector, SocketAddress address, Map<String, Object> context) throws IOException {
        context.put(QuicConfiguration.CONTEXT_KEY, this.configuration);
        DatagramChannel channel = DatagramChannel.open();
        if (clientConnector.getBindAddress() == null) {
            channel.bind(null);
        }
        return new ClientConnector.Configurator.ChannelWithAddress((SelectableChannel)channel, address);
    }

    public EndPoint newEndPoint(ClientConnector clientConnector, SocketAddress address, SelectableChannel selectable, ManagedSelector selector, SelectionKey selectionKey) {
        return new DatagramChannelEndPoint((DatagramChannel)selectable, selector, selectionKey, clientConnector.getScheduler());
    }

    public Connection newConnection(ClientConnector clientConnector, SocketAddress address, EndPoint endPoint, Map<String, Object> context) {
        return (Connection)this.configurator.apply((Connection)new ClientQuicConnection(clientConnector, endPoint, context));
    }
}

