/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import com.acme.MockDataSource;
import com.acme.MockUserTransaction;
import jakarta.transaction.UserTransaction;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.file.Path;
import javax.naming.NamingException;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.JettyDemos;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.NamingDump;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServerWithAnnotations {
    public static Server createServer(int port) throws NamingException, FileNotFoundException {
        Server server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.addConfiguration(new Configuration[]{new EnvConfiguration(), new PlusConfiguration(), new AnnotationConfiguration()});
        webapp.setContextPath("/");
        Path warFile = JettyDemos.find("demo-spec/demo-spec-webapp/target/demo-spec-webapp-@VER@.war");
        webapp.setWar(warFile.toString());
        webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/jetty-jakarta-servlet-api-[^/]*\\.jar$");
        server.setHandler((Handler)webapp);
        new Transaction((UserTransaction)new MockUserTransaction());
        new EnvEntry((Object)webapp, "maxAmount", (Object)100.0, true);
        new Resource((Object)server, "jdbc/mydatasource", (Object)new MockDataSource());
        server.addBean((Object)new NamingDump());
        String realmResourceName = "etc/realm.properties";
        ClassLoader classLoader = ServerWithAnnotations.class.getClassLoader();
        URL realmProps = classLoader.getResource(realmResourceName);
        if (realmProps == null) {
            throw new FileNotFoundException("Unable to find " + realmResourceName);
        }
        HashLoginService loginService = new HashLoginService();
        loginService.setName("Test Realm");
        loginService.setConfig(realmProps.toExternalForm());
        server.addBean((Object)loginService);
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ServerWithAnnotations.createServer(port);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

