/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.warurl;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Manifest;
import org.eclipse.jetty.osgi.boot.warurl.internal.WarBundleManifestGenerator;
import org.eclipse.jetty.osgi.boot.warurl.internal.WarURLConnection;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class WarUrlStreamHandler
extends AbstractURLStreamHandlerService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection openConnection(URL url) throws IOException {
        File file;
        URL actual = new URL(url.toString().substring("war:".length()));
        if (!actual.getProtocol().equals("file") || !(file = new File(URIUtil.encodePath((String)actual.getPath()))).exists() || file.isDirectory()) {
            // empty if block
        }
        URLConnection ori = actual.openConnection();
        ori.setDefaultUseCaches(Resource.getDefaultUseCaches());
        JarURLConnection jarOri = null;
        try {
            if (ori instanceof JarURLConnection) {
                jarOri = (JarURLConnection)ori;
            } else {
                jarOri = (JarURLConnection)new URL("jar:" + actual.toString() + "!/").openConnection();
                jarOri.setDefaultUseCaches(Resource.getDefaultUseCaches());
            }
            Manifest mf = WarBundleManifestGenerator.createBundleManifest(jarOri.getManifest(), url, jarOri.getJarFile());
            try {
                jarOri.getJarFile().close();
                jarOri = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            WarURLConnection warURLConnection = new WarURLConnection(actual, mf);
            return warURLConnection;
        }
        finally {
            if (jarOri != null) {
                try {
                    jarOri.getJarFile().close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

