/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionFlusher
extends IteratingCallback {
    private static final Logger LOG = LoggerFactory.getLogger(InstructionFlusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Instruction> queue = new ArrayDeque<Instruction>();
    private final ByteBufferPool.Lease lease;
    private final QuicStreamEndPoint endPoint;
    private final long streamType;
    private boolean initialized;
    private Throwable terminated;

    public InstructionFlusher(QuicSession session, QuicStreamEndPoint endPoint, long streamType) {
        this.lease = new ByteBufferPool.Lease(session.getByteBufferPool());
        this.endPoint = endPoint;
        this.streamType = streamType;
    }

    public boolean offer(List<Instruction> instructions) {
        Throwable closed;
        try (AutoLock l = this.lock.lock();){
            closed = this.terminated;
            if (closed == null) {
                this.queue.addAll(instructions);
            }
        }
        return closed == null;
    }

    protected IteratingCallback.Action process() {
        ArrayList<Instruction> instructions;
        try (AutoLock l = this.lock.lock();){
            if (this.queue.isEmpty()) {
                IteratingCallback.Action action = IteratingCallback.Action.IDLE;
                return action;
            }
            instructions = new ArrayList<Instruction>(this.queue);
            this.queue.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", instructions, (Object)this);
        }
        instructions.forEach(i -> i.encode(this.lease));
        if (!this.initialized) {
            this.initialized = true;
            ByteBuffer buffer = ByteBuffer.allocate(VarLenInt.length(this.streamType));
            VarLenInt.encode(buffer, this.streamType);
            buffer.flip();
            this.lease.insert(0, buffer, false);
        }
        List buffers = this.lease.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} buffers ({} bytes) on {}", new Object[]{buffers.size(), this.lease.getTotalLength(), this});
        }
        this.endPoint.write((Callback)this, (ByteBuffer[])buffers.toArray(ByteBuffer[]::new));
        return IteratingCallback.Action.SCHEDULED;
    }

    public void succeeded() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("succeeded to write {} on {}", (Object)this.lease.getByteBuffers(), (Object)this);
        }
        this.lease.recycle();
        super.succeeded();
    }

    protected void onCompleteFailure(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to write {} on {}", new Object[]{this.lease.getByteBuffers(), this, failure});
        }
        this.lease.recycle();
        try (AutoLock l = this.lock.lock();){
            this.terminated = failure;
            this.queue.clear();
        }
        long error = HTTP3ErrorCode.INTERNAL_ERROR.code();
        this.endPoint.close(error, failure);
        this.endPoint.getQuicSession().getProtocolSession().outwardClose(error, "instruction_stream_failure");
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.NON_BLOCKING;
    }

    public String toString() {
        return String.format("%s#%s", super.toString(), this.endPoint.getStreamId());
    }
}

