/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import com.acme.MockDataSource;
import com.acme.MockUserTransaction;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.eclipse.jetty.demos.ExampleUtil;
import org.eclipse.jetty.demos.JettyDemos;
import org.eclipse.jetty.jndi.factories.MailSessionReference;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServerWithJNDI {
    public static Server createServer(int port) throws NamingException, FileNotFoundException {
        Server server = new Server(port);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        Path testJndiWar = JettyDemos.find("demo-jndi-webapp/target/demo-jndi-webapp-@VER@.war");
        webapp.setWarResource((org.eclipse.jetty.util.resource.Resource)new PathResource(testJndiWar));
        server.setHandler((Handler)webapp);
        webapp.addConfiguration(new Configuration[]{new EnvConfiguration(), new PlusConfiguration()});
        new Transaction((UserTransaction)new MockUserTransaction());
        new EnvEntry((Object)server, "woggle", (Object)4000, false);
        new EnvEntry((Object)webapp, "wiggle", (Object)100.0, true);
        MailSessionReference mailref = new MailSessionReference();
        mailref.setUser("CHANGE-ME");
        mailref.setPassword("CHANGE-ME");
        Properties props = new Properties();
        props.put("mail.smtp.auth", "false");
        props.put("mail.smtp.host", "CHANGE-ME");
        props.put("mail.from", "CHANGE-ME");
        props.put("mail.debug", "false");
        mailref.setProperties(props);
        new Resource((Object)webapp, "mail/Session", (Object)mailref);
        new Resource((Object)webapp, "jdbc/mydatasource", (Object)new MockDataSource());
        return server;
    }

    public static void main(String[] args) throws Exception {
        int port = ExampleUtil.getPort(args, "jetty.http.port", 8080);
        Server server = ServerWithJNDI.createServer(port);
        server.start();
        server.join();
    }
}

