/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.TimeoutException;

public class OptimalModelIterator
extends PBSolverDecorator {
    private final long bound;
    protected long nbModelFound = 0L;
    private boolean trivialfalsity = false;
    private boolean isFirstModel = true;
    private BigInteger objectiveValue;
    private final IPBSolver solver;
    private static final long serialVersionUID = 1L;

    public OptimalModelIterator(IPBSolver solver) {
        this(solver, Long.MAX_VALUE);
    }

    public OptimalModelIterator(IPBSolver solver, long bound) {
        super(solver);
        this.solver = solver;
        this.bound = bound;
    }

    public int[] model() {
        int[] last = super.model();
        ++this.nbModelFound;
        try {
            ObjectiveFunction obj = this.getObjectiveFunction();
            if (this.isFirstModel && obj != null) {
                this.objectiveValue = obj.calculateDegree((RandomAccessModel)this.solver);
                this.solver.addAtMost(obj.getVars(), obj.getCoeffs(), this.objectiveValue);
                this.isFirstModel = false;
            }
        }
        catch (ContradictionException e) {
            this.trivialfalsity = true;
        }
        return last;
    }

    public boolean isSatisfiable() throws TimeoutException {
        if (this.trivialfalsity || this.nbModelFound >= this.bound) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(true);
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        if (this.trivialfalsity || this.nbModelFound >= this.bound) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(assumps, true);
    }

    public void reset() {
        this.trivialfalsity = false;
        this.nbModelFound = 0L;
        super.reset();
    }
}

