/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;

public class X509CertificateResourceImpl
extends ResourceImpl {
    private static Pattern PEM_PATTERN = Pattern.compile("-----BEGIN CERTIFICATE-----\r?\n(.*)\r?\n-----END CERTIFICATE-----\r?\n?", 32);
    private Certificate certificate;

    public X509CertificateResourceImpl(URI uri) {
        super(uri);
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            byte[] bytes = inputStream.readAllBytes();
            String value = new String(bytes, StandardCharsets.US_ASCII);
            Matcher matcher = PEM_PATTERN.matcher(value);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
            if (matcher.matches()) {
                String base64 = matcher.group(1);
                byte[] certificate = Base64.getMimeDecoder().decode(base64);
                this.certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(certificate));
                annotation.setSource(value);
            } else {
                this.certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
                annotation.setSource(XMLTypeFactory.eINSTANCE.convertBase64Binary(bytes));
            }
            this.getContents().add((Object)annotation);
        }
        catch (CertificateException ex) {
            throw new IOException(ex);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        String value = this.getValue();
        if (value != null) {
            if (PEM_PATTERN.matcher(value).matches()) {
                outputStream.write(value.getBytes(StandardCharsets.US_ASCII));
            } else {
                outputStream.write(XMLTypeFactory.eINSTANCE.createBase64Binary(value));
            }
        }
    }

    protected String getValue() {
        Annotation annotation = (Annotation)EcoreUtil.getObjectByType((Collection)this.getContents(), (EClassifier)BasePackage.Literals.ANNOTATION);
        if (annotation != null) {
            return annotation.getSource();
        }
        return null;
    }
}

