/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageSelectionProvider
implements IPostSelectionProvider {
    private final ListenerList<ISelectionChangedListener> listeners = new ListenerList();
    private final ListenerList<ISelectionChangedListener> postListeners = new ListenerList();
    private final MultiPageEditorPart multiPageEditor;

    public MultiPageSelectionProvider(MultiPageEditorPart multiPageEditor) {
        Assert.isNotNull((Object)multiPageEditor);
        this.multiPageEditor = multiPageEditor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.add((Object)listener);
    }

    public void fireSelectionChanged(SelectionChangedEvent event) {
        this.fireEventChange(event, this.listeners);
    }

    public void firePostSelectionChanged(SelectionChangedEvent event) {
        this.fireEventChange(event, this.postListeners);
    }

    private void fireEventChange(final SelectionChangedEvent event, ListenerList<ISelectionChangedListener> listenersList) {
        for (final ISelectionChangedListener l : listenersList) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }

    public MultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor = this.multiPageEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider selectionProvider;
        IEditorPart activeEditor = this.multiPageEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection(selection);
        }
    }
}

