/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.oomph.internal.util.UtilPlugin;
import org.eclipse.oomph.util.AccessUtil;
import org.eclipse.oomph.util.Messages;
import org.eclipse.osgi.util.NLS;

public final class ReflectUtil {
    private static final Set<Field> FINAL_FIELDS = ConcurrentHashMap.newKeySet();

    private ReflectUtil() {
    }

    public static <T> Constructor<T> getConstructor(Class<T> c, Class<?> ... parameterTypes) {
        try {
            Constructor<T> constructor = c.getDeclaredConstructor(parameterTypes);
            ReflectUtil.makeAccessible(constructor);
            return constructor;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && "org.eclipse.core.runtime.OperationCanceledException".equals(cause.getClass().getName())) {
                throw (RuntimeException)cause;
            }
            throw new ReflectionException(cause);
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Method getMethod(Object target, String methodName, Class<?> ... parameterTypes) {
        return ReflectUtil.getMethod(target.getClass(), methodName, parameterTypes);
    }

    public static Method getMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            try {
                Method method = c.getDeclaredMethod(methodName, parameterTypes);
                ReflectUtil.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException ex) {
                Class<?> superclass = c.getSuperclass();
                if (superclass != null) {
                    return ReflectUtil.getMethod(superclass, methodName, parameterTypes);
                }
                throw ex;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> T invokeMethod(Method method, Object target, Object ... arguments) {
        try {
            Object value = method.invoke(target, arguments);
            return (T)value;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && "org.eclipse.core.runtime.OperationCanceledException".equals(cause.getClass().getName())) {
                throw (RuntimeException)cause;
            }
            throw new ReflectionException(cause);
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> T invokeMethod(String methodName, Object target) {
        if (target instanceof Class) {
            return ReflectUtil.invokeMethod(ReflectUtil.getMethod((Class)target, methodName, new Class[0]), null, new Object[0]);
        }
        return ReflectUtil.invokeMethod(ReflectUtil.getMethod(target.getClass(), methodName, new Class[0]), target, new Object[0]);
    }

    public static Field getField(Class<?> c, String fieldName) {
        try {
            try {
                Field field = c.getDeclaredField(fieldName);
                ReflectUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException ex) {
                Class<?> superclass = c.getSuperclass();
                if (superclass != null) {
                    return ReflectUtil.getField(superclass, fieldName);
                }
                return null;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> T getValue(Field field, Object target) {
        try {
            Object value = field.get(target);
            return (T)value;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    public static <T> T getValue(String fieldName, Object target) {
        if (target instanceof Class) {
            Field field = ReflectUtil.getField((Class)target, fieldName);
            if (field == null) {
                throw new ReflectionException(NLS.bind((String)Messages.ReflectUtil_NoField_exception, (Object)fieldName));
            }
            return ReflectUtil.getValue(field, null);
        }
        Field field = ReflectUtil.getField(target.getClass(), fieldName);
        if (field == null) {
            throw new ReflectionException(NLS.bind((String)Messages.ReflectUtil_NoField_exception, (Object)fieldName));
        }
        return ReflectUtil.getValue(field, target);
    }

    public static void setValue(String fieldName, Object target, Object value) {
        if (target instanceof Class) {
            ReflectUtil.setValue(ReflectUtil.getField((Class)target, fieldName), null, value);
        } else {
            ReflectUtil.setValue(ReflectUtil.getField(target.getClass(), fieldName), target, value);
        }
    }

    public static void setValue(Field field, Object target, Object value) {
        ReflectUtil.setValue(field, target, value, false);
    }

    public static void setValue(Field field, Object target, Object value, boolean force) {
        try {
            Class<?> type;
            if ((field.getModifiers() & 0x10) != 0 && FINAL_FIELDS.add(field)) {
                RuntimeException runtimeException = new RuntimeException("Cannot modify a final field: " + String.valueOf(field));
                runtimeException.fillInStackTrace();
                UtilPlugin.INSTANCE.log(runtimeException, 1);
            }
            if ((field.getModifiers() & 0x10) != 0 && force) {
                AccessUtil.setNonFinal(field);
            }
            if ((type = field.getType()).isPrimitive()) {
                if (Boolean.TYPE == type) {
                    field.setBoolean(target, (Boolean)value);
                } else if (Character.TYPE == type) {
                    field.setChar(target, ((Character)value).charValue());
                } else if (Byte.TYPE == type) {
                    field.setByte(target, (Byte)value);
                } else if (Short.TYPE == type) {
                    field.setShort(target, (Short)value);
                } else if (Integer.TYPE == type) {
                    field.setInt(target, (Integer)value);
                } else if (Long.TYPE == type) {
                    field.setLong(target, (Long)value);
                } else if (Float.TYPE == type) {
                    field.setFloat(target, ((Float)value).floatValue());
                } else if (Double.TYPE == type) {
                    field.setDouble(target, (Double)value);
                }
            } else {
                field.set(target, value);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ReflectionException(ex);
        }
    }

    private static <T> void makeAccessible(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    public static class ReflectionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReflectionException() {
        }

        public ReflectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(Throwable cause) {
            super(cause);
        }
    }
}

