/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.core;

import java.security.cert.Certificate;
import java.util.ArrayList;
import org.eclipse.equinox.p2.core.UIServices;

public class CertificateConfirmer {
    public static final CertificateConfirmer ACCEPT = new CertificateConfirmer(){

        public boolean isTrusted(Certificate[] certificateChain) {
            return true;
        }
    };
    public static final CertificateConfirmer DECLINE = new CertificateConfirmer(){

        public boolean isDecline() {
            return true;
        }
    };
    public static final CertificateConfirmer ALWAYS_PROMPT = new CertificateConfirmer();

    public boolean isTrusted(Certificate[] certificateChain) {
        return false;
    }

    public void trust(Certificate[] certificateChain) {
    }

    public boolean isDecline() {
        return false;
    }

    public final Certificate[][] getUntrustedCertificates(Certificate[][] untrustedChains) {
        if (untrustedChains == null || untrustedChains.length == 0 || this.isDecline()) {
            return untrustedChains;
        }
        ArrayList<Certificate[]> result = new ArrayList<Certificate[]>();
        Certificate[][] certificateArray = untrustedChains;
        int n = untrustedChains.length;
        int n2 = 0;
        while (n2 < n) {
            Certificate[] untrustedChain = certificateArray[n2];
            if (!this.isTrusted(untrustedChain)) {
                result.add(untrustedChain);
            }
            ++n2;
        }
        return (Certificate[][])result.toArray((T[])new Certificate[result.size()][]);
    }

    public static class TrustInfoWithPolicy
    extends UIServices.TrustInfo {
        private final boolean trustAll;

        public TrustInfoWithPolicy(Certificate[] trusted, boolean save, boolean trustUnsigned, boolean trustAll) {
            super(trusted, save, trustUnsigned);
            this.trustAll = trustAll;
        }

        public boolean isTrustAll() {
            return this.trustAll;
        }
    }
}

