/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class ReferenceHashSet<T> {
    HashedReference<T>[] values;
    public int elementSize = 0;
    int threshold;
    ReferenceQueue<T> referenceQueue = new ReferenceQueue();
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;

    public ReferenceHashSet() {
        this(5);
    }

    public ReferenceHashSet(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.values = new HashedReference[extraRoom];
    }

    private HashedReference<T> toReference(int type, T referent) {
        switch (type) {
            case 0: {
                return new StrongReference<T>(referent, this.referenceQueue);
            }
            case 1: {
                return new HashableSoftReference<T>(referent, this.referenceQueue);
            }
            case 2: {
                return new HashableWeakReference<T>(referent, this.referenceQueue);
            }
        }
        throw new Error();
    }

    public T add(T obj, int referenceType) {
        HashedReference<T> currentValue;
        this.cleanupGarbageCollectedValues();
        int index = (obj.hashCode() & Integer.MAX_VALUE) % this.values.length;
        while ((currentValue = this.values[index]) != null) {
            T referent = currentValue.get();
            if (obj.equals(referent)) {
                return referent;
            }
            index = (index + 1) % this.values.length;
        }
        this.values[index] = this.toReference(referenceType, obj);
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return obj;
    }

    private void addValue(HashedReference<T> value) {
        HashedReference<T> currentValue;
        T obj = value.get();
        if (obj == null) {
            return;
        }
        int valuesLength = this.values.length;
        int index = (value.hashCode() & Integer.MAX_VALUE) % valuesLength;
        while ((currentValue = this.values[index]) != null) {
            if (obj.equals(currentValue.get())) {
                return;
            }
            index = (index + 1) % valuesLength;
        }
        this.values[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
    }

    private void cleanupGarbageCollectedValues() {
        HashedReference toBeRemoved;
        block0: while ((toBeRemoved = (HashedReference)((Object)this.referenceQueue.poll())) != null) {
            HashedReference<T> currentValue;
            int hashCode = toBeRemoved.hashCode();
            int valuesLength = this.values.length;
            int index = (hashCode & Integer.MAX_VALUE) % valuesLength;
            while ((currentValue = this.values[index]) != null) {
                if (currentValue == toBeRemoved) {
                    int current;
                    int sameHash = index;
                    while ((currentValue = this.values[current = (sameHash + 1) % valuesLength]) != null && currentValue.hashCode() == hashCode) {
                        sameHash = current;
                    }
                    this.values[index] = this.values[sameHash];
                    this.values[sameHash] = null;
                    --this.elementSize;
                    continue block0;
                }
                index = (index + 1) % valuesLength;
            }
        }
    }

    public boolean contains(T obj) {
        return this.get(obj) != null;
    }

    public T get(T obj) {
        HashedReference<T> currentValue;
        this.cleanupGarbageCollectedValues();
        int valuesLength = this.values.length;
        int index = (obj.hashCode() & Integer.MAX_VALUE) % valuesLength;
        while ((currentValue = this.values[index]) != null) {
            T referent = currentValue.get();
            if (obj.equals(referent)) {
                return referent;
            }
            index = (index + 1) % valuesLength;
        }
        return null;
    }

    private void rehash() {
        ReferenceHashSet<T> newHashSet = new ReferenceHashSet<T>(this.elementSize * 2);
        newHashSet.referenceQueue = this.referenceQueue;
        int i = 0;
        int length = this.values.length;
        while (i < length) {
            HashedReference<T> currentValue = this.values[i];
            if (currentValue != null) {
                super.addValue(currentValue);
            }
            ++i;
        }
        this.values = newHashSet.values;
        this.threshold = newHashSet.threshold;
        this.elementSize = newHashSet.elementSize;
    }

    public Object remove(T obj) {
        HashedReference<T> currentValue;
        this.cleanupGarbageCollectedValues();
        int valuesLength = this.values.length;
        int index = (obj.hashCode() & Integer.MAX_VALUE) % valuesLength;
        while ((currentValue = this.values[index]) != null) {
            T referent = currentValue.get();
            if (obj.equals(referent)) {
                --this.elementSize;
                this.values[index] = null;
                this.rehash();
                return referent;
            }
            index = (index + 1) % valuesLength;
        }
        return null;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("{");
        int i = 0;
        int length = this.values.length;
        while (i < length) {
            T ref;
            HashedReference<T> value = this.values[i];
            if (value != null && (ref = value.get()) != null) {
                buffer.append(ref);
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public Object[] toArray() {
        this.cleanupGarbageCollectedValues();
        Object[] result = new Object[this.elementSize];
        int resultSize = 0;
        HashedReference<T>[] hashedReferenceArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            T tmp;
            HashedReference<T> value = hashedReferenceArray[n2];
            if (value != null && (tmp = value.get()) != null) {
                result[resultSize++] = tmp;
            }
            ++n2;
        }
        if (result.length == resultSize) {
            return result;
        }
        Object[] finalResult = new Object[resultSize];
        System.arraycopy(result, 0, finalResult, 0, resultSize);
        return finalResult;
    }

    private class HashableSoftReference<U>
    extends SoftReference<U>
    implements HashedReference<U> {
        public int hashCode;

        public HashableSoftReference(U referent, ReferenceQueue<? super U> queue) {
            super(referent, queue);
            this.hashCode = referent.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HashableWeakReference)) {
                return false;
            }
            Object referent = super.get();
            Object other = ((HashableWeakReference)obj).get();
            if (referent == null) {
                return other == null;
            }
            return referent.equals(other);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Object referent = super.get();
            if (referent == null) {
                return "[hashCode=" + this.hashCode + "] <referent was garbage collected>";
            }
            return "[hashCode=" + this.hashCode + "] " + referent;
        }
    }

    private class HashableWeakReference<U>
    extends WeakReference<U>
    implements HashedReference<U> {
        public int hashCode;

        public HashableWeakReference(U referent, ReferenceQueue<? super U> queue) {
            super(referent, queue);
            this.hashCode = referent.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HashableWeakReference)) {
                return false;
            }
            Object referent = super.get();
            Object other = ((HashableWeakReference)obj).get();
            if (referent == null) {
                return other == null;
            }
            return referent.equals(other);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Object referent = super.get();
            if (referent == null) {
                return "[hashCode=" + this.hashCode + "] <referent was garbage collected>";
            }
            return "[hashCode=" + this.hashCode + "] " + referent;
        }
    }

    private static interface HashedReference<T> {
        public int hashCode();

        public T get();
    }

    private class StrongReference<U>
    implements HashedReference<U> {
        private U referent;

        public StrongReference(U referent, ReferenceQueue<? super U> queue) {
            this.referent = referent;
        }

        @Override
        public int hashCode() {
            return this.referent.hashCode();
        }

        @Override
        public U get() {
            return this.referent;
        }

        public boolean equals(Object obj) {
            return this.referent.equals(obj);
        }
    }
}

