/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.felix.scr.impl.ScrGogoCommand;
import org.apache.felix.scr.impl.ScrShellCommand;
import org.apache.felix.scr.impl.config.ScrConfigurationImpl;
import org.apache.felix.scr.info.ScrInfo;
import org.apache.felix.shell.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;

public class ScrCommand
implements ScrInfo {
    private static final Comparator<ComponentDescriptionDTO> DESCRIPTION_COMP = new Comparator<ComponentDescriptionDTO>(){

        @Override
        public int compare(ComponentDescriptionDTO c1, ComponentDescriptionDTO c2) {
            long bundleId1 = c1.bundle.id;
            long bundleId2 = c2.bundle.id;
            int result = Long.signum(bundleId1 - bundleId2);
            if (result == 0) {
                result = c1.name == null ? (c2.name == null ? 0 : -1) : (c2.name == null ? 1 : c1.name.compareTo(c2.name));
            }
            return result;
        }
    };
    private static final Comparator<ComponentConfigurationDTO> CONFIGURATION_COMP = new Comparator<ComponentConfigurationDTO>(){

        @Override
        public int compare(ComponentConfigurationDTO c1, ComponentConfigurationDTO c2) {
            return Long.signum(c1.id - c2.id);
        }
    };
    private final BundleContext bundleContext;
    private final ServiceComponentRuntime scrService;
    private final ScrConfigurationImpl scrConfiguration;
    private ServiceRegistration<ScrInfo> reg;
    private ServiceRegistration<?> gogoReg;
    private ServiceRegistration<?> shellReg;

    static ScrCommand register(BundleContext bundleContext, ServiceComponentRuntime scrService, ScrConfigurationImpl scrConfiguration) {
        ScrCommand cmd = new ScrCommand(bundleContext, scrService, scrConfiguration);
        cmd.registerCommands(bundleContext, scrService);
        return cmd;
    }

    protected ScrCommand(BundleContext bundleContext, ServiceComponentRuntime scrService, ScrConfigurationImpl scrConfiguration) {
        this.bundleContext = bundleContext;
        this.scrService = scrService;
        this.scrConfiguration = scrConfiguration;
    }

    private void registerCommands(BundleContext bundleContext, ServiceComponentRuntime scrService) {
        try {
            ScrGogoCommand gogoCmd = new ScrGogoCommand(this);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("osgi.command.scope", "scr");
            props.put("osgi.command.function", new String[]{"config", "disable", "enable", "info", "list"});
            props.put("service.description", "SCR Gogo Shell Support");
            props.put("service.vendor", "The Apache Software Foundation");
            this.gogoReg = bundleContext.registerService(ScrGogoCommand.class, (Object)gogoCmd, props);
        }
        catch (Throwable gogoCmd) {
            // empty catch block
        }
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("service.description", "SCR Legacy Shell Support");
            props.put("service.vendor", "The Apache Software Foundation");
            this.shellReg = bundleContext.registerService(Command.class, (Object)new ScrShellCommand(this), props);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void unregister() {
        if (this.gogoReg != null) {
            this.gogoReg.unregister();
            this.gogoReg = null;
        }
        if (this.shellReg != null) {
            this.shellReg.unregister();
            this.shellReg = null;
        }
    }

    public void update(boolean infoAsService) {
        if (infoAsService) {
            if (this.reg == null) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("service.description", "SCR Info service");
                props.put("service.vendor", "The Apache Software Foundation");
                this.reg = this.bundleContext.registerService(ScrInfo.class, (Object)this, props);
            }
        } else if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    private static boolean isBundleActive(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getState() == 32) {
                return true;
            }
            if (bundle.getState() == 8) {
                return bundle.getHeaders("").get("Bundle-ActivationPolicy") != null;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void list(String bundleIdentifier, PrintWriter out) {
        ArrayList descriptions = new ArrayList();
        if (bundleIdentifier != null) {
            Bundle bundle = null;
            try {
                long bundleId = Long.parseLong(bundleIdentifier);
                bundle = this.bundleContext.getBundle(bundleId);
            }
            catch (NumberFormatException nfe) {
                Bundle[] bundles = this.bundleContext.getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    if (!bundleIdentifier.equals(bundles[i].getSymbolicName())) continue;
                    bundle = bundles[i];
                    break;
                }
            }
            if (bundle == null) {
                throw new IllegalArgumentException("Missing bundle with ID " + bundleIdentifier);
            }
            if (!ScrCommand.isBundleActive(bundle)) {
                out.println("Bundle " + bundleIdentifier + " is not active");
                return;
            }
            descriptions.addAll(this.scrService.getComponentDescriptionDTOs(new Bundle[]{bundle}));
            if (descriptions.isEmpty()) {
                out.println("Bundle " + bundleIdentifier + " declares no components");
                return;
            }
        } else {
            descriptions.addAll(this.scrService.getComponentDescriptionDTOs(new Bundle[0]));
            if (descriptions.isEmpty()) {
                out.println("No components registered");
                return;
            }
        }
        Collections.sort(descriptions, DESCRIPTION_COMP);
        out.println(" BundleId Component Name Default State");
        out.println("    Component Id State      PIDs (Factory PID)");
        Iterator iterator = descriptions.iterator();
        block3: while (true) {
            if (!iterator.hasNext()) {
                out.flush();
                return;
            }
            ComponentDescriptionDTO desc = (ComponentDescriptionDTO)iterator.next();
            out.println(String.format(" [%1$4d]   %2$s  %3$s", desc.bundle.id, desc.name, desc.defaultEnabled ? "enabled" : "disabled"));
            ArrayList configs = new ArrayList(this.scrService.getComponentConfigurationDTOs(desc));
            Collections.sort(configs, CONFIGURATION_COMP);
            Iterator iterator2 = configs.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block3;
                ComponentConfigurationDTO component = (ComponentConfigurationDTO)iterator2.next();
                Object servicePid = component.properties.get("service.pid");
                String factoryPid = (String)component.properties.get("service.factoryPid");
                StringBuilder pid = new StringBuilder();
                if (servicePid != null) {
                    pid.append(servicePid);
                }
                if (factoryPid != null) {
                    pid.append(" (");
                    pid.append(factoryPid);
                    pid.append(" )");
                }
                out.println(String.format("    [%1$4d] [%2$s] %3$s", component.id, this.toStateString(component.state), pid.toString()));
            }
            break;
        }
    }

    @Override
    public void info(String componentId, PrintWriter out) {
        Result result = this.getComponentsFromArg(componentId, false);
        if (result.components.isEmpty()) {
            return;
        }
        Collections.sort(result.components, DESCRIPTION_COMP);
        long bundleId = -1L;
        for (ComponentDescriptionDTO component : result.components) {
            ReferenceDTO[] refs;
            String[] services;
            if (component.bundle.id != bundleId) {
                if (bundleId != -1L) {
                    out.println();
                }
                bundleId = component.bundle.id;
                out.println(String.format("*** Bundle: %1$s (%2$d)", component.bundle.symbolicName, bundleId));
            }
            out.println("Component Description:");
            out.print("  Name: ");
            out.println(component.name);
            out.print("  Implementation Class: ");
            out.println(component.implementationClass);
            out.print("  Default State: ");
            out.println(component.defaultEnabled ? "enabled" : "disabled");
            out.print("  Activation: ");
            out.println(component.immediate ? "immediate" : "delayed");
            out.print("  Configuration Policy: ");
            out.println(component.configurationPolicy);
            out.print("  Activate Method: ");
            out.print(component.activate);
            out.println();
            out.print("  Deactivate Method: ");
            out.print(component.deactivate);
            out.println();
            out.print("  Modified Method: ");
            if (component.modified != null) {
                out.print(component.modified);
            } else {
                out.print("-");
            }
            out.println();
            out.print("  Configuration Pid: ");
            out.print(Arrays.asList(component.configurationPid));
            out.println();
            if (component.factory != null) {
                out.print("  Factory: ");
                out.println(component.factory);
            }
            if ((services = component.serviceInterfaces) != null && services.length > 0) {
                out.println("  Services: ");
                for (String service : services) {
                    out.print("    ");
                    out.println(service);
                }
                out.print("  Service Scope: ");
                out.println(component.scope);
            }
            if ((refs = component.references) != null) {
                for (ReferenceDTO ref : refs) {
                    out.print("  Reference: ");
                    out.println(ref.name);
                    out.print("    Interface Name: ");
                    out.println(ref.interfaceName);
                    if (ref.target != null) {
                        out.print("    Target Filter: ");
                        out.println(ref.target);
                    }
                    out.print("    Cardinality: ");
                    out.println(ref.cardinality);
                    out.print("    Policy: ");
                    out.println(ref.policy);
                    out.print("    Policy option: ");
                    out.println(ref.policyOption);
                    out.print("    Reference Scope: ");
                    out.println(ref.scope);
                }
            }
            Map props = component.properties;
            this.propertyInfo(props, out, "  ", "Component Description");
            if (result.configuration != null) {
                this.info(result.configuration, out);
            } else {
                Collection componentConfigurationDTOs = this.scrService.getComponentConfigurationDTOs(component);
                if (componentConfigurationDTOs.isEmpty()) {
                    out.println("  (No Component Configurations)");
                } else {
                    for (ComponentConfigurationDTO cc : componentConfigurationDTOs) {
                        this.info(cc, out);
                    }
                }
            }
            out.println();
        }
        out.flush();
    }

    void propertyInfo(Map<String, Object> props, PrintWriter out, String prefix, String label) {
        if (props != null) {
            out.print(prefix);
            out.print(label);
            out.println(" Properties:");
            TreeMap<String, Object> keys = new TreeMap<String, Object>(props);
            for (Map.Entry<String, Object> entry : keys.entrySet()) {
                out.print(prefix);
                out.print("    ");
                out.print(entry.getKey());
                out.print(" = ");
                Object prop = entry.getValue();
                if (prop.getClass().isArray()) {
                    out.print("[");
                    int length = Array.getLength(prop);
                    for (int i = 0; i < length; ++i) {
                        out.print(Array.get(prop, i));
                        if (i >= length - 1) continue;
                        out.print(", ");
                    }
                    out.println("]");
                    continue;
                }
                out.println(prop);
            }
        }
    }

    private void info(ComponentConfigurationDTO cc, PrintWriter out) {
        ServiceReferenceDTO[] serviceRefs;
        out.println("  Component Configuration:");
        out.print("    ComponentId: ");
        out.println(cc.id);
        out.print("    State: ");
        out.println(this.toStateString(cc.state));
        for (SatisfiedReferenceDTO satisfiedReferenceDTO : cc.satisfiedReferences) {
            out.print("    SatisfiedReference: ");
            out.println(satisfiedReferenceDTO.name);
            out.print("      Target: ");
            out.println(satisfiedReferenceDTO.target);
            serviceRefs = satisfiedReferenceDTO.boundServices;
            if (serviceRefs.length > 0) {
                out.print("      Bound to:");
                for (ServiceReferenceDTO sr : serviceRefs) {
                    out.print("        ");
                    out.println(sr.id);
                    this.propertyInfo(sr.properties, out, "      ", "Reference");
                }
                continue;
            }
            out.println("      (unbound)");
        }
        for (SatisfiedReferenceDTO satisfiedReferenceDTO : cc.unsatisfiedReferences) {
            out.print("    UnsatisfiedReference: ");
            out.println(satisfiedReferenceDTO.name);
            out.print("      Target: ");
            out.println(satisfiedReferenceDTO.target);
            serviceRefs = satisfiedReferenceDTO.targetServices;
            if (serviceRefs.length > 0) {
                out.print("      Target services:");
                for (ServiceReferenceDTO sr : serviceRefs) {
                    out.print("        ");
                    out.println(sr.id);
                }
                continue;
            }
            out.println("      (no target services)");
        }
        this.propertyInfo(cc.properties, out, "    ", "Component Configuration");
    }

    void change(String componentIdentifier, PrintWriter out, boolean enable) {
        Result result = this.getComponentsFromArg(componentIdentifier, true);
        for (ComponentDescriptionDTO component : result.components) {
            if (enable) {
                if (!this.scrService.isComponentEnabled(component)) {
                    this.scrService.enableComponent(component);
                    out.println("Component " + component.name + " enabled");
                    continue;
                }
                out.println("Component " + component.name + " already enabled");
                continue;
            }
            if (this.scrService.isComponentEnabled(component)) {
                this.scrService.disableComponent(component);
                out.println("Component " + component.name + " disabled");
                continue;
            }
            out.println("Component " + component.name + " already disabled");
        }
        out.flush();
    }

    @Override
    public void config(PrintWriter out) {
        out.print("Log Level: ");
        out.println(this.scrConfiguration.getLogLevel());
        out.print("Obsolete Component Factory with Factory Configuration: ");
        out.println(this.scrConfiguration.isFactoryEnabled() ? "Supported" : "Unsupported");
        out.print("Keep instances with no references: ");
        out.println(this.scrConfiguration.keepInstances() ? "Supported" : "Unsupported");
        out.print("Lock timeount milliseconds: ");
        out.println(this.scrConfiguration.lockTimeout());
        out.print("Stop timeount milliseconds: ");
        out.println(this.scrConfiguration.stopTimeout());
        out.print("Global extender: ");
        out.println(this.scrConfiguration.globalExtender());
        out.print("Info Service registered: ");
        out.println(this.scrConfiguration.infoAsService() ? "Supported" : "Unsupported");
        out.flush();
    }

    private String toStateString(int state) {
        switch (state) {
            case 2: {
                return "unsatisfied reference";
            }
            case 8: {
                return "active      ";
            }
            case 4: {
                return "satisfied   ";
            }
            case 1: {
                return "unsatisfied config";
            }
        }
        return "unkown: " + state;
    }

    private Result getComponentsFromArg(String componentIdentifier, boolean nameMatch) {
        Pattern p = componentIdentifier == null ? null : Pattern.compile(componentIdentifier);
        Result result = new Result();
        for (ComponentDescriptionDTO cmp : this.scrService.getComponentDescriptionDTOs(new Bundle[0])) {
            if (componentIdentifier != null) {
                if (p.matcher(cmp.name).matches()) {
                    result.components.add(cmp);
                    continue;
                }
                if (nameMatch) continue;
                boolean done = false;
                for (ComponentConfigurationDTO cfg : this.scrService.getComponentConfigurationDTOs(cmp)) {
                    if (!p.matcher(String.valueOf(cfg.id)).matches()) continue;
                    result.components.add(cmp);
                    result.configuration = cfg;
                    done = true;
                    break;
                }
                if (!done) continue;
                break;
            }
            result.components.add(cmp);
        }
        if (componentIdentifier != null && result.components.isEmpty()) {
            throw new IllegalArgumentException("No Component with name or configuration with ID matching " + componentIdentifier);
        }
        return result;
    }

    private static final class Result {
        public List<ComponentDescriptionDTO> components = new ArrayList<ComponentDescriptionDTO>();
        public ComponentConfigurationDTO configuration;

        private Result() {
        }
    }
}

