/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.DeferredImageDescriptor;
import org.eclipse.jface.resource.DerivedImageDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDataImageDescriptor;
import org.eclipse.jface.resource.URLImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class ImageDescriptor
extends DeviceResourceDescriptor<Image> {
    protected static final ImageData DEFAULT_IMAGE_DATA = new ImageData(6, 6, 1, new PaletteData(new RGB[]{new RGB(255, 0, 0)}));
    private static final ImageDescriptor NULL_IMAGE = ImageDescriptor.createFromImageDataProvider(z -> null);
    private static final ImageDescriptor MISSING_IMAGE = ImageDescriptor.createFromImageDataProvider(z -> z == 100 ? DEFAULT_IMAGE_DATA : null);

    protected ImageDescriptor() {
    }

    ImageDescriptor(boolean shouldBeCached) {
        super(shouldBeCached);
    }

    public static ImageDescriptor createFromFile(Class<?> location, String filename) {
        URL url;
        if (location == null) {
            try {
                url = IPath.fromOSString((String)filename).toPath().toUri().toURL();
            }
            catch (MalformedURLException e) {
                Policy.logException(e);
                url = null;
            }
        } else {
            url = location.getResource(filename);
        }
        if (url == null) {
            return NULL_IMAGE;
        }
        return new URLImageDescriptor(url);
    }

    @Deprecated
    public static ImageDescriptor createFromImageData(ImageData data) {
        return new ImageDataImageDescriptor(data);
    }

    public static ImageDescriptor createFromImageDataProvider(ImageDataProvider provider) {
        return new ImageDataImageDescriptor(provider);
    }

    public static ImageDescriptor createFromImage(Image img) {
        return new ImageDataImageDescriptor(img);
    }

    public static ImageDescriptor createWithFlags(ImageDescriptor originalImage, int swtFlags) {
        return new DerivedImageDescriptor(originalImage, swtFlags);
    }

    @Deprecated
    public static ImageDescriptor createFromImage(Image img, Device theDevice) {
        return new ImageDataImageDescriptor(img);
    }

    public static ImageDescriptor createFromURL(URL url) {
        if (url == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return new URLImageDescriptor(url);
    }

    public static ImageDescriptor createFromURLSupplier(boolean useMissingImage, Supplier<URL> supplier) {
        return new DeferredImageDescriptor(useMissingImage, supplier);
    }

    public static ImageDescriptor createFromURI(URI uriIconPath) {
        try {
            return ImageDescriptor.createFromURL(uriIconPath != null ? uriIconPath.toURL() : null);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    @Deprecated(since="3.36", forRemoval=true)
    public ImageDescriptor imageDescriptorFromURI(URI uriIconPath) {
        return ImageDescriptor.createFromURI(uriIconPath);
    }

    @Override
    public Object createResource(Device device) throws DeviceResourceException {
        Image result = this.createImage(false, device);
        if (result == null) {
            throw new DeviceResourceException(this);
        }
        return result;
    }

    @Override
    public void destroyResource(Object previouslyCreatedObject) {
        ((Image)previouslyCreatedObject).dispose();
    }

    public Image createImage() {
        return this.createImage(true);
    }

    public Image createImage(boolean returnMissingImageOnError) {
        return this.createImage(returnMissingImageOnError, (Device)Display.getCurrent());
    }

    public Image createImage(Device device) {
        return this.createImage(true, device);
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        try {
            return new Image(device, this::getImageData);
        }
        catch (IllegalArgumentException | SWTException e) {
            if (returnMissingImageOnError) {
                try {
                    return new Image(device, DEFAULT_IMAGE_DATA);
                }
                catch (SWTException e2) {
                    return null;
                }
            }
            return null;
        }
    }

    public ImageData getImageData(int zoom) {
        if (zoom == 100) {
            return this.getImageData();
        }
        return null;
    }

    @Deprecated
    public ImageData getImageData() {
        return this.getImageData(100);
    }

    public static ImageDescriptor getMissingImageDescriptor() {
        return MISSING_IMAGE;
    }
}

