/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.completion;

public class CommandLineParser {
    private static final char[] delimiters = new char[]{'|', ';', '=', '{', '}', '(', ')', '$', '>', ']', ' '};
    private static final String COMMENT_CHAR = "#";
    private static final String HASH_MAP_DEF_START_CHAR = "<";
    private static final String HASH_MAP_DEF_END_CHAR = ">";
    private static final String LIST_DEF_START_CHAR = "[";

    public static String getCurrentToken(String commandLine, int cursor) {
        String current = commandLine.substring(0, cursor);
        int currentStartIdx = -1;
        char[] cArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char delimiter = cArray[n2];
            int idx = current.lastIndexOf(delimiter);
            if (delimiter == '=' && idx > -1) {
                int startAngleBraceIdx = current.substring(0, idx).lastIndexOf(HASH_MAP_DEF_START_CHAR);
                int endAngleBraceBeforeAssignmentIdx = current.substring(0, idx).lastIndexOf(HASH_MAP_DEF_END_CHAR);
                int endAngleBraceAfterAssignmentIdx = current.substring(idx + 1).indexOf(HASH_MAP_DEF_END_CHAR);
                if (startAngleBraceIdx > -1 && startAngleBraceIdx < idx && endAngleBraceBeforeAssignmentIdx == -1 && endAngleBraceAfterAssignmentIdx == -1) {
                    return null;
                }
            }
            if (idx > currentStartIdx) {
                currentStartIdx = idx;
            }
            ++n2;
        }
        if (currentStartIdx + 1 == current.length()) {
            return "";
        }
        if (currentStartIdx + 1 > current.length()) {
            return null;
        }
        String currentToken = current.substring(currentStartIdx + 1, current.length());
        if (currentToken.contains(COMMENT_CHAR) || currentToken.contains(HASH_MAP_DEF_START_CHAR) || currentToken.contains(LIST_DEF_START_CHAR)) {
            return null;
        }
        return currentToken;
    }
}

