/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.LineDelimiterEditor;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class IDEWorkspacePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IEclipseContext e4Context;
    private IntegerFieldEditor saveInterval;
    private StringFieldEditor workspaceName;
    private Button showLocationPathInTitle;
    private Button showLocationNameInTitle;
    private Button showPerspectiveNameInTitle;
    private Button showProductNameInTitle;
    private Button showActiveEditorInfoInTitle;
    private Button autoRefreshButton;
    private Button lightweightRefreshButton;
    private Button closeUnrelatedProjectButton;
    private ResourceEncodingFieldEditor encodingEditor;
    private LineDelimiterEditor lineSeparatorEditor;
    private boolean clearUserSettings = false;
    private ComboFieldEditor openReferencesEditor;
    private StringFieldEditor systemExplorer;
    private ComboFieldEditor missingNatureSeverityCombo;
    private ComboFieldEditor missingEncodingSeverityCombo;
    private boolean showLocationIsSetOnCommandLine;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.workspace_preference_page_context");
        Composite composite = this.createComposite(parent);
        PreferenceLinkArea area = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.Startup", IDEWorkbenchMessages.IDEWorkspacePreference_relatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(768);
        area.getControl().setLayoutData((Object)data);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createAutoRefreshControls(composite);
        this.createCloseUnrelatedProjPrefControls(composite);
        this.createSaveIntervalGroup(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createWorkspaceLocationGroup(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        Composite comboParent = new Composite(composite, 0);
        comboParent.setLayout((Layout)new GridLayout(2, false));
        this.createOpenPrefControls(comboParent);
        this.createMissingNaturePref(comboParent);
        this.createMissingEncodingPref(comboParent);
        IDEWorkspacePreferencePage.createSpace(composite);
        this.createSystemExplorerGroup(composite);
        IDEWorkspacePreferencePage.createSpace(composite);
        Composite lower = new Composite(composite, 0);
        GridLayout lowerLayout = new GridLayout();
        lowerLayout.marginWidth = 0;
        lowerLayout.numColumns = 2;
        lowerLayout.makeColumnsEqualWidth = true;
        lower.setLayout((Layout)lowerLayout);
        lower.setLayoutData((Object)new GridData(768));
        this.createEncodingEditorControls(lower);
        this.createLineSeparatorEditorControls(lower);
        this.applyDialogFont(composite);
        return composite;
    }

    private void createMissingNaturePref(Composite parent) {
        this.missingNatureSeverityCombo = new ComboFieldEditorInGrid("missingNatureMarkerSeverity", IDEWorkbenchMessages.IDEWorkspacePreference_UnknownNatureSeverity, new String[][]{{IDEWorkbenchMessages.IDEWorkspacePreference_UnknownNatureSeverity_Ignore, Integer.toString(-1)}, {MarkerMessages.propertiesDialog_infoLabel, Integer.toString(0)}, {MarkerMessages.propertiesDialog_warningLabel, Integer.toString(1)}, {MarkerMessages.propertiesDialog_errorLabel, Integer.toString(2)}}, parent);
        this.missingNatureSeverityCombo.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.core.resources"));
        this.missingNatureSeverityCombo.setPage((DialogPage)this);
        this.missingNatureSeverityCombo.load();
    }

    private void createMissingEncodingPref(Composite parent) {
        this.missingEncodingSeverityCombo = new ComboFieldEditorInGrid("missingEncodingMarkerSeverity", IDEWorkbenchMessages.IDEWorkspacePreference_UnknownEncodingSeverity, new String[][]{{IDEWorkbenchMessages.IDEWorkspacePreference_UnknownEncodingSeverity_Ignore, Integer.toString(-1)}, {MarkerMessages.propertiesDialog_infoLabel, Integer.toString(0)}, {MarkerMessages.propertiesDialog_warningLabel, Integer.toString(1)}, {MarkerMessages.propertiesDialog_errorLabel, Integer.toString(2)}}, parent);
        this.missingEncodingSeverityCombo.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.core.resources"));
        this.missingEncodingSeverityCombo.setPage((DialogPage)this);
        this.missingEncodingSeverityCombo.load();
    }

    private void createOpenPrefControls(Composite parent) {
        String name = "OPEN_REQUIRED_PROJECTS";
        String label = IDEWorkbenchMessages.IDEWorkspacePreference_openReferencedProjects;
        String[][] namesAndValues = new String[][]{{Action.removeMnemonics((String)IDEWorkbenchMessages.Always), "always"}, {Action.removeMnemonics((String)IDEWorkbenchMessages.Never), "never"}, {Action.removeMnemonics((String)IDEWorkbenchMessages.Prompt), "prompt"}};
        this.openReferencesEditor = new ComboFieldEditorInGrid(name, label, namesAndValues, parent);
        this.openReferencesEditor.setPreferenceStore(this.getIDEPreferenceStore());
        this.openReferencesEditor.setPage((DialogPage)this);
        this.openReferencesEditor.load();
    }

    private void createCloseUnrelatedProjPrefControls(Composite parent) {
        this.closeUnrelatedProjectButton = new Button(parent, 32);
        this.closeUnrelatedProjectButton.setText(IDEWorkbenchMessages.CloseUnrelatedProjectsAction_AlwaysCloseWithoutPrompt);
        this.closeUnrelatedProjectButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_closeUnrelatedProjectsToolTip);
        this.closeUnrelatedProjectButton.setSelection(this.getIDEPreferenceStore().getBoolean("CLOSE_UNRELATED_PROJECTS"));
    }

    private void createWorkspaceLocationGroup(Composite composite) {
        boolean isShowLocation = this.getIDEPreferenceStore().getBoolean("SHOW_LOCATION") || this.showLocationIsSetOnCommandLine;
        boolean isShowName = this.getIDEPreferenceStore().getBoolean("SHOW_LOCATION_NAME");
        boolean isShowPerspective = this.getIDEPreferenceStore().getBoolean("SHOW_PERSPECTIVE_IN_TITLE");
        boolean isShowProduct = this.getIDEPreferenceStore().getBoolean("SHOW_PRODUCT_IN_TITLE");
        boolean isShowActiveEditorInfo = this.getIDEPreferenceStore().getBoolean("SHOW_ACTIVE_EDITOR_INFO_IN_TITLE");
        Composite groupComposite = new Composite(composite, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)groupComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(groupComposite);
        GridLayout gl = (GridLayout)groupComposite.getLayout();
        gl.horizontalSpacing = 0;
        Group grpWindowTitle = new Group(groupComposite, 0);
        grpWindowTitle.setText(IDEWorkbenchMessages.IDEWorkspacePreference_windowTitleGroupText);
        grpWindowTitle.setLayout((Layout)new GridLayout(1, false));
        grpWindowTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite locationNameComposite = new Composite((Composite)grpWindowTitle, 0);
        GridDataFactory.defaultsFor((Control)locationNameComposite).indent(0, 0).grab(true, false).applyTo((Control)locationNameComposite);
        GridLayout locationNameLayout = new GridLayout(2, false);
        locationNameComposite.setLayout((Layout)locationNameLayout);
        locationNameLayout.marginHeight = 0;
        locationNameLayout.marginWidth = 0;
        this.showLocationNameInTitle = new Button(locationNameComposite, 32);
        this.showLocationNameInTitle.setText(IDEWorkbenchMessages.IDEWorkspacePreference_showLocationNameInWindowTitle);
        this.showLocationNameInTitle.setSelection(isShowName);
        Composite workspaceNameComposite = new Composite(locationNameComposite, 0);
        GridDataFactory.defaultsFor((Control)workspaceNameComposite).align(4, 0x1000000).grab(true, false).applyTo((Control)workspaceNameComposite);
        this.workspaceName = new StringFieldEditor("WORKSPACE_NAME", "", workspaceNameComposite);
        this.workspaceName.setPreferenceStore(this.getIDEPreferenceStore());
        this.workspaceName.load();
        this.workspaceName.setPage((DialogPage)this);
        this.showPerspectiveNameInTitle = new Button((Composite)grpWindowTitle, 32);
        this.showPerspectiveNameInTitle.setText(IDEWorkbenchMessages.IDEWorkspacePreference_showPerspectiveNameInWindowTitle);
        this.showPerspectiveNameInTitle.setSelection(isShowPerspective);
        Composite pathComposite = new Composite((Composite)grpWindowTitle, 0);
        pathComposite.setLayoutData((Object)GridDataFactory.copyData((GridData)((GridData)locationNameComposite.getLayoutData())));
        pathComposite.setLayout((Layout)GridLayoutFactory.copyLayout((GridLayout)((GridLayout)locationNameComposite.getLayout())));
        this.showLocationPathInTitle = new Button(pathComposite, 32);
        this.showLocationPathInTitle.setText(IDEWorkbenchMessages.IDEWorkspacePreference_showLocationInWindowTitle);
        this.showLocationPathInTitle.setSelection(isShowLocation);
        Text workspacePath = new Text(pathComposite, 8);
        workspacePath.setBackground(workspacePath.getDisplay().getSystemColor(22));
        workspacePath.setText(TextProcessor.process((String)Platform.getLocation().toOSString()));
        workspacePath.setSelection(workspacePath.getText().length());
        workspacePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.showProductNameInTitle = new Button((Composite)grpWindowTitle, 32);
        this.showProductNameInTitle.setText(IDEWorkbenchMessages.IDEWorkspacePreference_showProductNameInWindowTitle);
        this.showProductNameInTitle.setSelection(isShowProduct);
        this.showActiveEditorInfoInTitle = new Button((Composite)grpWindowTitle, 32);
        this.showActiveEditorInfoInTitle.setText(IDEWorkbenchMessages.IDEWorkspacePreference_showActiveEditorInfoInWindowTitle);
        this.showActiveEditorInfoInTitle.setSelection(isShowActiveEditorInfo);
        if (this.showLocationIsSetOnCommandLine) {
            Stream.of(this.showLocationPathInTitle, workspacePath).forEach(c -> c.setEnabled(false));
            pathComposite.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_showLocationSetOnCommandLine);
        }
    }

    private void createSaveIntervalGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        this.saveInterval = new IntegerFieldEditor("saveInterval", IDEWorkbenchMessages.WorkbenchPreference_saveInterval, groupComposite);
        this.saveInterval.setPreferenceStore(this.getIDEPreferenceStore());
        this.saveInterval.setPage((DialogPage)this);
        this.saveInterval.setTextLimit(Integer.toString(9999).length());
        this.saveInterval.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_saveIntervalError, (Object)9999));
        this.saveInterval.setValidateStrategy(0);
        this.saveInterval.setValidRange(1, 9999);
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        long interval = description.getSnapshotInterval() / 60000L;
        this.saveInterval.setStringValue(Long.toString(interval));
        this.saveInterval.setPropertyChangeListener(event -> {
            if (event.getProperty().equals("field_editor_is_valid")) {
                this.setValid(this.saveInterval.isValid());
            }
        });
    }

    private void createAutoRefreshControls(Composite parent) {
        this.autoRefreshButton = new Button(parent, 32);
        this.autoRefreshButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshButtonText);
        this.autoRefreshButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshButtonToolTip);
        this.lightweightRefreshButton = new Button(parent, 32);
        this.lightweightRefreshButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshLightweightButtonText);
        this.lightweightRefreshButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_RefreshLightweightButtonToolTip);
        boolean lightweightRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null);
        boolean autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.enabled", false, null);
        this.autoRefreshButton.setSelection(autoRefresh);
        this.lightweightRefreshButton.setSelection(lightweightRefresh);
    }

    private void createEncodingEditorControls(Composite parent) {
        Composite encodingComposite = new Composite(parent, 0);
        encodingComposite.setLayout((Layout)new GridLayout());
        encodingComposite.setLayoutData((Object)new GridData(768));
        this.encodingEditor = new ResourceEncodingFieldEditor(IDEWorkbenchMessages.WorkbenchPreference_encoding, encodingComposite, (IResource)ResourcesPlugin.getWorkspace().getRoot());
        this.encodingEditor.setPage((DialogPage)this);
        this.encodingEditor.load();
        this.encodingEditor.setPropertyChangeListener(event -> {
            if (event.getProperty().equals("field_editor_is_valid")) {
                this.setValid(this.encodingEditor.isValid());
            }
        });
    }

    private void createLineSeparatorEditorControls(Composite parent) {
        Composite lineComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        lineComposite.setLayout((Layout)gridLayout);
        lineComposite.setLayoutData((Object)new GridData(768));
        this.lineSeparatorEditor = new LineDelimiterEditor(lineComposite);
        this.lineSeparatorEditor.doLoad();
    }

    protected void createSystemExplorerGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        this.systemExplorer = new StringFieldEditor("SYSTEM_EXPLORER", IDEWorkbenchMessages.IDEWorkbenchPreference_workbenchSystemExplorer, 40, groupComposite);
        Text textControl = this.systemExplorer.getTextControl(groupComposite);
        BidiUtils.applyBidiProcessing((Text)textControl, (String)"ltr");
        gd = (GridData)textControl.getLayoutData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.systemExplorer.setPreferenceStore(this.getIDEPreferenceStore());
        this.systemExplorer.setPage((DialogPage)this);
        this.systemExplorer.load();
        this.systemExplorer.setPropertyChangeListener(event -> {
            if (event.getProperty().equals("field_editor_is_valid")) {
                this.setValid(this.systemExplorer.isValid());
            }
        });
    }

    protected IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.e4Context = (IEclipseContext)workbench.getService(IEclipseContext.class);
        this.showLocationIsSetOnCommandLine = this.e4Context.containsKey("forcedShowLocation");
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getIDEPreferenceStore();
        this.saveInterval.loadDefault();
        if (!this.showLocationIsSetOnCommandLine) {
            boolean showLocationPath = store.getDefaultBoolean("SHOW_LOCATION");
            this.showLocationPathInTitle.setSelection(showLocationPath);
        }
        boolean showLocationName = store.getDefaultBoolean("SHOW_LOCATION_NAME");
        boolean showPerspectiveName = store.getDefaultBoolean("SHOW_PERSPECTIVE_IN_TITLE");
        boolean showProductName = store.getDefaultBoolean("SHOW_PRODUCT_IN_TITLE");
        boolean showActiveEditorInfo = store.getDefaultBoolean("SHOW_ACTIVE_EDITOR_INFO_IN_TITLE");
        this.showLocationNameInTitle.setSelection(showLocationName);
        this.showPerspectiveNameInTitle.setSelection(showPerspectiveName);
        this.showProductNameInTitle.setSelection(showProductName);
        this.showActiveEditorInfoInTitle.setSelection(showActiveEditorInfo);
        this.workspaceName.loadDefault();
        boolean closeUnrelatedProj = store.getDefaultBoolean("CLOSE_UNRELATED_PROJECTS");
        this.closeUnrelatedProjectButton.setSelection(closeUnrelatedProj);
        boolean lightweightRefresh = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("refresh.lightweight.enabled");
        boolean autoRefresh = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultBoolean("refresh.enabled");
        this.autoRefreshButton.setSelection(autoRefresh);
        this.lightweightRefreshButton.setSelection(lightweightRefresh);
        this.clearUserSettings = true;
        List encodings = WorkbenchEncoding.getDefinedEncodings();
        encodings.sort(null);
        this.encodingEditor.loadDefault();
        this.lineSeparatorEditor.loadDefault();
        this.openReferencesEditor.loadDefault();
        this.missingNatureSeverityCombo.loadDefault();
        this.missingEncodingSeverityCombo.loadDefault();
        this.systemExplorer.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        long newSaveInterval;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        IPreferenceStore store = this.getIDEPreferenceStore();
        long oldSaveInterval = description.getSnapshotInterval() / 60000L;
        if (oldSaveInterval != (newSaveInterval = Long.parseLong(this.saveInterval.getStringValue()))) {
            try {
                description.setSnapshotInterval(newSaveInterval * 60000L);
                ResourcesPlugin.getWorkspace().setDescription(description);
                store.firePropertyChangeEvent("saveInterval", (Object)((int)oldSaveInterval), (Object)((int)newSaveInterval));
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing save interval preference", e.getStatus());
            }
        }
        if (!this.showLocationIsSetOnCommandLine) {
            store.setValue("SHOW_LOCATION", this.showLocationPathInTitle.getSelection());
        }
        store.setValue("SHOW_LOCATION_NAME", this.showLocationNameInTitle.getSelection());
        store.setValue("SHOW_PERSPECTIVE_IN_TITLE", this.showPerspectiveNameInTitle.getSelection());
        store.setValue("SHOW_PRODUCT_IN_TITLE", this.showProductNameInTitle.getSelection());
        store.setValue("SHOW_ACTIVE_EDITOR_INFO_IN_TITLE", this.showActiveEditorInfoInTitle.getSelection());
        this.workspaceName.store();
        this.systemExplorer.store();
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        boolean autoRefresh = this.autoRefreshButton.getSelection();
        preferences.setValue("refresh.enabled", autoRefresh);
        boolean lightweightRefresh = this.lightweightRefreshButton.getSelection();
        preferences.setValue("refresh.lightweight.enabled", lightweightRefresh);
        boolean closeUnrelatedProj = this.closeUnrelatedProjectButton.getSelection();
        this.getIDEPreferenceStore().setValue("CLOSE_UNRELATED_PROJECTS", closeUnrelatedProj);
        if (this.clearUserSettings) {
            IDEEncoding.clearUserEncodings();
        }
        this.encodingEditor.store();
        this.lineSeparatorEditor.store();
        this.openReferencesEditor.store();
        this.missingNatureSeverityCombo.store();
        this.missingEncodingSeverityCombo.store();
        return super.performOk();
    }

    private static class ComboFieldEditorInGrid
    extends ComboFieldEditor {
        public ComboFieldEditorInGrid(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
            super(name, labelText, entryNamesAndValues, parent);
        }

        protected void createControl(Composite parent) {
            super.fillIntoGrid(parent, 2);
        }
    }
}

