/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.animation.effects;

import org.eclipse.nebula.cwt.animation.AnimationRunner;
import org.eclipse.nebula.cwt.animation.effects.AbstractEffect;
import org.eclipse.nebula.cwt.animation.movement.IMovement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class Resize
extends AbstractEffect {
    Point src;
    Point dest;
    Point diff;
    Control control = null;

    public static void resize(AnimationRunner runner, Control w, int x, int y, int duration, IMovement movement, Runnable onStop, Runnable onCancel) {
        Point oldSize = w.getSize();
        Resize effect = new Resize(w, oldSize, new Point(x, y), duration, movement, onStop, onCancel);
        runner.runEffect(effect);
    }

    public Resize(Control control, Point src, Point dest, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.src = src;
        this.dest = dest;
        this.diff = new Point(dest.x - src.x, dest.y - src.y);
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
        this.control = control;
    }

    @Override
    public void applyEffect(long currentTime) {
        if (!this.control.isDisposed()) {
            this.control.setSize((int)((double)this.src.x + (double)this.diff.x * this.easingFunction.getValue((int)currentTime)), (int)((double)this.src.y + (double)this.diff.y * this.easingFunction.getValue((int)currentTime)));
        }
    }
}

