/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.projectconfig.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.util.BaseSwitch;
import org.eclipse.oomph.predicates.AndPredicate;
import org.eclipse.oomph.predicates.NotPredicate;
import org.eclipse.oomph.predicates.OrPredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.util.PredicatesSwitch;
import org.eclipse.oomph.projectconfig.ProjectConfigFactory;
import org.eclipse.oomph.projectconfig.provider.ExclusionPredicateItemProvider;
import org.eclipse.oomph.projectconfig.provider.InclusionPredicateItemProvider;
import org.eclipse.oomph.projectconfig.provider.PreferenceFilterItemProvider;
import org.eclipse.oomph.projectconfig.provider.PreferenceProfileItemProvider;
import org.eclipse.oomph.projectconfig.provider.ProjectConfigEditPlugin;
import org.eclipse.oomph.projectconfig.provider.ProjectItemProvider;
import org.eclipse.oomph.projectconfig.provider.WorkspaceConfigurationItemProvider;
import org.eclipse.oomph.projectconfig.util.ProjectConfigAdapterFactory;

public class ProjectConfigItemProviderAdapterFactory
extends ProjectConfigAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Disposable disposable = new Disposable();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected WorkspaceConfigurationItemProvider workspaceConfigurationItemProvider;
    protected InclusionPredicateItemProvider inclusionPredicateItemProvider;
    protected ExclusionPredicateItemProvider exclusionPredicateItemProvider;

    public ProjectConfigItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createWorkspaceConfigurationAdapter() {
        if (this.workspaceConfigurationItemProvider == null) {
            this.workspaceConfigurationItemProvider = new WorkspaceConfigurationItemProvider((AdapterFactory)this);
        }
        return this.workspaceConfigurationItemProvider;
    }

    public Adapter createProjectAdapter() {
        return new ProjectItemProvider((AdapterFactory)this);
    }

    public Adapter createPreferenceProfileAdapter() {
        return new PreferenceProfileItemProvider((AdapterFactory)this);
    }

    public Adapter createPreferenceFilterAdapter() {
        return new PreferenceFilterItemProvider((AdapterFactory)this);
    }

    public Adapter createInclusionPredicateAdapter() {
        if (this.inclusionPredicateItemProvider == null) {
            this.inclusionPredicateItemProvider = new InclusionPredicateItemProvider((AdapterFactory)this);
        }
        return this.inclusionPredicateItemProvider;
    }

    public Adapter createExclusionPredicateAdapter() {
        if (this.exclusionPredicateItemProvider == null) {
            this.exclusionPredicateItemProvider = new ExclusionPredicateItemProvider((AdapterFactory)this);
        }
        return this.exclusionPredicateItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    protected void associate(Adapter adapter, Notifier target) {
        super.associate(adapter, target);
        if (adapter != null) {
            this.disposable.add((Object)adapter);
        }
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        this.disposable.dispose();
    }

    public static class BaseChildCreationExtender
    implements IChildCreationExtender {
        public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
            ArrayList<Object> result = new ArrayList<Object>();
            new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
            return result;
        }

        public ResourceLocator getResourceLocator() {
            return ProjectConfigEditPlugin.INSTANCE;
        }

        protected static class CreationSwitch
        extends BaseSwitch<Object> {
            protected List<Object> newChildDescriptors;
            protected EditingDomain editingDomain;

            CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            public Object caseAnnotation(Annotation object) {
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, ProjectConfigFactory.eINSTANCE.createWorkspaceConfiguration()));
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, ProjectConfigFactory.eINSTANCE.createProject()));
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, ProjectConfigFactory.eINSTANCE.createPreferenceProfile()));
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, ProjectConfigFactory.eINSTANCE.createPreferenceFilter()));
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, ProjectConfigFactory.eINSTANCE.createInclusionPredicate()));
                this.newChildDescriptors.add(this.createChildParameter(BasePackage.Literals.ANNOTATION__CONTENTS, ProjectConfigFactory.eINSTANCE.createExclusionPredicate()));
                return null;
            }

            protected CommandParameter createChildParameter(Object feature, Object child) {
                return new CommandParameter(null, feature, child);
            }
        }
    }

    public static class PredicatesChildCreationExtender
    implements IChildCreationExtender {
        public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
            ArrayList<Object> result = new ArrayList<Object>();
            new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
            return result;
        }

        public ResourceLocator getResourceLocator() {
            return ProjectConfigEditPlugin.INSTANCE;
        }

        protected static class CreationSwitch
        extends PredicatesSwitch<Object> {
            protected List<Object> newChildDescriptors;
            protected EditingDomain editingDomain;

            CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
                this.newChildDescriptors = newChildDescriptors;
                this.editingDomain = editingDomain;
            }

            public Object caseAndPredicate(AndPredicate object) {
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.AND_PREDICATE__OPERANDS, ProjectConfigFactory.eINSTANCE.createInclusionPredicate()));
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.AND_PREDICATE__OPERANDS, ProjectConfigFactory.eINSTANCE.createExclusionPredicate()));
                return null;
            }

            public Object caseOrPredicate(OrPredicate object) {
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.OR_PREDICATE__OPERANDS, ProjectConfigFactory.eINSTANCE.createInclusionPredicate()));
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.OR_PREDICATE__OPERANDS, ProjectConfigFactory.eINSTANCE.createExclusionPredicate()));
                return null;
            }

            public Object caseNotPredicate(NotPredicate object) {
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.NOT_PREDICATE__OPERAND, ProjectConfigFactory.eINSTANCE.createInclusionPredicate()));
                this.newChildDescriptors.add(this.createChildParameter(PredicatesPackage.Literals.NOT_PREDICATE__OPERAND, ProjectConfigFactory.eINSTANCE.createExclusionPredicate()));
                return null;
            }

            protected CommandParameter createChildParameter(Object feature, Object child) {
                return new CommandParameter(null, feature, child);
            }
        }
    }
}

