/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;

public class SymmetricKeyEncSessionPacket
extends ContainedPacket {
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int VERSION_6 = 6;
    private int version;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] s2kBytes;
    private byte[] secKeyData;
    private int aeadAlgorithm;
    private byte[] iv;
    private byte[] authTag;

    public SymmetricKeyEncSessionPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    public SymmetricKeyEncSessionPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(3, bl);
        this.version = bCPGInputStream.read();
        if (this.version == 4) {
            this.encAlgorithm = bCPGInputStream.read();
            this.s2k = new S2K(bCPGInputStream);
            this.secKeyData = bCPGInputStream.readAll();
        } else if (this.version == 5 || this.version == 6) {
            int n;
            int n2 = 0;
            if (this.version == 6) {
                n2 = bCPGInputStream.read();
            }
            this.encAlgorithm = bCPGInputStream.read();
            this.aeadAlgorithm = bCPGInputStream.read();
            if (this.version == 6) {
                n = bCPGInputStream.read();
                n2 = n2 - 3 - n;
            } else {
                n2 = AEADUtils.getIVLength(this.aeadAlgorithm);
            }
            this.s2k = new S2K(bCPGInputStream);
            this.iv = new byte[n2];
            if (bCPGInputStream.read(this.iv) != this.iv.length) {
                throw new EOFException("Premature end of stream.");
            }
            n = AEADUtils.getAuthTagLength(this.aeadAlgorithm);
            this.authTag = new byte[n];
            byte[] byArray = bCPGInputStream.readAll();
            this.secKeyData = new byte[byArray.length - n];
            System.arraycopy(byArray, 0, this.secKeyData, 0, this.secKeyData.length);
            System.arraycopy(byArray, this.secKeyData.length, this.authTag, 0, n);
        } else {
            throw new UnsupportedPacketVersionException("Unsupported PGP symmetric-key encrypted session key packet version encountered: " + this.version);
        }
    }

    public static SymmetricKeyEncSessionPacket createV4Packet(int n, S2K s2K, byte[] byArray) {
        return new SymmetricKeyEncSessionPacket(n, s2K, byArray);
    }

    public static SymmetricKeyEncSessionPacket createV5Packet(int n, int n2, byte[] byArray, S2K s2K, byte[] byArray2, byte[] byArray3) {
        return new SymmetricKeyEncSessionPacket(5, n, n2, byArray, s2K, byArray2, byArray3);
    }

    public static SymmetricKeyEncSessionPacket createV6Packet(int n, int n2, byte[] byArray, S2K s2K, byte[] byArray2, byte[] byArray3) {
        return new SymmetricKeyEncSessionPacket(6, n, n2, byArray, s2K, byArray2, byArray3);
    }

    public SymmetricKeyEncSessionPacket(int n, S2K s2K, byte[] byArray) {
        super(3);
        this.version = 4;
        this.encAlgorithm = n;
        this.s2k = s2K;
        this.secKeyData = byArray;
    }

    private SymmetricKeyEncSessionPacket(int n, int n2, int n3, byte[] byArray, S2K s2K, byte[] byArray2, byte[] byArray3) {
        super(3);
        this.version = n;
        this.encAlgorithm = n2;
        this.aeadAlgorithm = n3;
        this.s2k = s2K;
        this.secKeyData = byArray2;
        int n4 = AEADUtils.getIVLength(n3);
        if (n4 != byArray.length) {
            throw new IllegalArgumentException("Mismatched AEAD IV length. Expected " + n4 + ", got " + byArray.length);
        }
        this.iv = byArray;
        int n5 = AEADUtils.getAuthTagLength(n3);
        if (n5 != byArray3.length) {
            throw new IllegalArgumentException("Mismatched AEAD AuthTag length. Expected " + n5 + ", got " + byArray3.length);
        }
        this.authTag = byArray3;
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public byte[] getSecKeyData() {
        return this.secKeyData;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getAuthTag() {
        return this.authTag;
    }

    public byte[] getAAData() {
        return SymmetricKeyEncSessionPacket.createAAData(this.getVersion(), this.getEncAlgorithm(), this.getAeadAlgorithm());
    }

    public static byte[] createAAData(int n, int n2, int n3) {
        byte[] byArray = new byte[]{-61, (byte)(n & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 & 0xFF)};
        return byArray;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = this.version == 4 ? new BCPGOutputStream(byteArrayOutputStream) : new BCPGOutputStream((OutputStream)byteArrayOutputStream, true);
        bCPGOutputStream2.write(this.version);
        if (this.version == 4) {
            bCPGOutputStream2.write(this.encAlgorithm);
            bCPGOutputStream2.writeObject(this.s2k);
            if (this.secKeyData != null && this.secKeyData.length > 0) {
                bCPGOutputStream2.write(this.secKeyData);
            }
        } else if (this.version == 5 || this.version == 6) {
            int n = this.s2k.getEncoded().length;
            int n2 = 3 + n + this.iv.length;
            bCPGOutputStream2.write(n2);
            bCPGOutputStream2.write(this.encAlgorithm);
            bCPGOutputStream2.write(this.aeadAlgorithm);
            bCPGOutputStream2.write(n);
            bCPGOutputStream2.writeObject(this.s2k);
            bCPGOutputStream2.write(this.iv);
            if (this.secKeyData != null && this.secKeyData.length > 0) {
                bCPGOutputStream2.write(this.secKeyData);
            }
            bCPGOutputStream2.write(this.authTag);
        }
        bCPGOutputStream2.close();
        bCPGOutputStream.writePacket(this.hasNewPacketFormat(), 3, byteArrayOutputStream.toByteArray());
    }
}

