/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.operations.IProfileChangeJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;

public class ProfileModificationJob
extends ProvisioningJob
implements IProfileChangeJob {
    IProvisioningPlan plan;
    String profileId;
    IPhaseSet phaseSet = PhaseSetFactory.createDefaultPhaseSet();
    ProvisioningContext provisioningContext;
    int restartPolicy = 2;
    private String taskName;

    public ProfileModificationJob(String name, ProvisioningSession session, String profileId, IProvisioningPlan plan, ProvisioningContext context) {
        super(name, session);
        this.plan = plan;
        this.profileId = profileId;
        this.provisioningContext = context;
    }

    public void setPhaseSet(IPhaseSet phaseSet) {
        this.phaseSet = phaseSet;
    }

    @Override
    public String getProfileId() {
        return this.profileId;
    }

    @Override
    public IStatus runModal(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String task = this.taskName;
        IStatus status = Status.OK_STATUS;
        if (task == null) {
            task = this.getName();
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)task, (int)1000);
            status = this.getSession().performProvisioningPlan(this.plan, this.phaseSet, this.provisioningContext, (IProgressMonitor)subMonitor);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public void setTaskName(String label) {
        this.taskName = label;
    }

    @Override
    public int getRestartPolicy() {
        String id;
        if ("_SELF_".equals(this.profileId)) {
            return this.restartPolicy;
        }
        IProfile profile = this.getSession().getProfileRegistry().getProfile("_SELF_");
        String string = id = profile == null ? null : profile.getProfileId();
        if (id != null && this.profileId.equals(id)) {
            return this.restartPolicy;
        }
        return 1;
    }

    public void setRestartPolicy(int policy) {
        this.restartPolicy = policy;
    }
}

