/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.overview;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.figures.IStyledFigure;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewCursorLayer;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewEventLayer;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewSelectionLayer;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;

public class OverviewFigure
extends LayeredPane
implements IStyledFigure {
    private static final int DEFAULT_HEIGHT = 80;
    public static final int VERTICAL_INDENT = 8;
    public static final int Y_PADDING = 3;
    private final int fPreferredHeight = 80;
    private int fEventHeight = 0;
    private Insets fAdditionalInsets;

    public OverviewFigure(ITimelineStyleProvider styleProvider) {
        this.add((IFigure)new OverviewEventLayer(styleProvider));
        this.add((IFigure)new OverviewCursorLayer());
        this.add((IFigure)new OverviewSelectionLayer(styleProvider));
        this.updateStyle(styleProvider);
    }

    @Override
    public void updateStyle(ITimelineStyleProvider styleProvider) {
        this.setVisible(styleProvider.showOverview());
        this.setBorder(styleProvider.getOverviewAreaBorder());
        this.fEventHeight = styleProvider.getOverviewLaneHeight();
        this.fAdditionalInsets = styleProvider.getOverviewInsets();
    }

    public Insets getInsets() {
        Insets insets = new Insets(super.getInsets());
        insets.add(this.fAdditionalInsets);
        return insets;
    }

    protected void layout() {
        super.layout();
        TimeBaseConverter timeConverter = RootFigure.getTimeViewDetails((IFigure)this);
        timeConverter.setOverviewScreenWidth(this.getBounds().width() - this.getInsets().getWidth());
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int laneCount = RootFigure.getLaneCount((IFigure)this);
        int requiredHeight = laneCount * this.fEventHeight + (laneCount + 1) * 3 + this.getInsets().getHeight();
        return new Dimension(wHint, Math.max(requiredHeight, 80));
    }
}

