/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.EventListener;
import java.util.Vector;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnGroupHeaderRenderer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridColumnGroup
extends Item {
    private Grid parent;
    private GridColumn[] columns = new GridColumn[0];
    private boolean expanded = true;
    private Font headerFont;
    private GridHeaderRenderer headerRenderer = new DefaultColumnGroupHeaderRenderer();

    public GridColumnGroup(Grid parent, int style) {
        super((Widget)parent, style);
        this.parent = parent;
        this.init(style);
        parent.newColumnGroup(this);
    }

    private void init(int style) {
        this.headerRenderer.setDisplay(this.getDisplay());
        if ((this.getStyle() & 0x20000) == 131072) {
            this.headerRenderer.setHorizontalAlignment(131072);
        }
        if ((this.getStyle() & 0x1000000) == 0x1000000) {
            this.headerRenderer.setHorizontalAlignment(0x1000000);
        }
    }

    public void addTreeListener(TreeListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{17, 18});
    }

    public void removeTreeListener(TreeListener listener) {
        this.removeTypedListener(17, (EventListener)listener);
        this.removeTypedListener(18, (EventListener)listener);
    }

    public Grid getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getNewColumnIndex() {
        if (this.columns.length == 0) {
            return -1;
        }
        GridColumn lastCol = this.columns[this.columns.length - 1];
        return lastCol.index + 1;
    }

    void newColumn(GridColumn column, int index) {
        GridColumn[] newAllColumns = new GridColumn[this.columns.length + 1];
        System.arraycopy(this.columns, 0, newAllColumns, 0, this.columns.length);
        newAllColumns[newAllColumns.length - 1] = column;
        this.columns = newAllColumns;
    }

    void removeColumn(GridColumn col) {
        if (this.columns.length == 0) {
            return;
        }
        GridColumn[] newAllColumns = new GridColumn[this.columns.length - 1];
        int x = 0;
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i] != col) {
                newAllColumns[x] = this.columns[i];
                ++x;
            }
            ++i;
        }
        this.columns = newAllColumns;
    }

    public GridColumn[] getColumns() {
        this.checkWidget();
        GridColumn[] newArray = new GridColumn[this.columns.length];
        System.arraycopy(this.columns, 0, newArray, 0, this.columns.length);
        return newArray;
    }

    public void dispose() {
        super.dispose();
        if (this.parent.isDisposing()) {
            return;
        }
        GridColumn[] oldColumns = this.columns;
        this.columns = new GridColumn[0];
        int i = 0;
        while (i < oldColumns.length) {
            oldColumns[i].dispose();
            ++i;
        }
        this.parent.removeColumnGroup(this);
    }

    public GridHeaderRenderer getHeaderRenderer() {
        this.checkWidget();
        return this.headerRenderer;
    }

    public void setHeaderRenderer(GridHeaderRenderer headerRenderer) {
        if (headerRenderer == null) {
            SWT.error((int)4);
        }
        this.headerRenderer = headerRenderer;
        headerRenderer.setDisplay(this.getDisplay());
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        if (!expanded && this.getParent().getCellSelectionEnabled()) {
            Vector<Integer> collapsedCols = new Vector<Integer>();
            int j = 0;
            while (j < this.columns.length) {
                if (!this.columns[j].isSummary()) {
                    collapsedCols.add(this.columns[j].index);
                }
                ++j;
            }
            Point[] selection = this.getParent().getCellSelection();
            int i = 0;
            while (i < selection.length) {
                if (collapsedCols.contains(selection[i].x)) {
                    this.getParent().deselectCell(selection[i]);
                }
                ++i;
            }
            if (this.getParent().getFocusColumn() != null && this.getParent().getFocusColumn().getColumnGroup() == this) {
                this.getParent().updateColumnFocus();
            }
            this.parent.updateColumnSelection();
        }
        if (this.parent.getCellSelectionEnabled()) {
            this.parent.refreshHoverState();
        }
        this.parent.setScrollValuesObsolete();
        this.parent.redraw();
    }

    GridColumn getFirstVisibleColumn() {
        GridColumn[] cols = this.parent.getColumnsInOrder();
        int i = 0;
        while (i < cols.length) {
            if (cols[i].getColumnGroup() == this && cols[i].isVisible()) {
                return cols[i];
            }
            ++i;
        }
        return null;
    }

    GridColumn getLastVisibleColumn() {
        GridColumn[] cols = this.parent.getColumnsInOrder();
        GridColumn lastVisible = null;
        int i = 0;
        while (i < cols.length) {
            if (cols[i].getColumnGroup() == this && cols[i].isVisible()) {
                lastVisible = cols[i];
            }
            ++i;
        }
        return lastVisible;
    }

    Rectangle getBounds() {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        bounds.height = this.parent.getGroupHeaderHeight();
        boolean foundFirstColumnInGroup = false;
        GridColumn[] cols = this.parent.getColumnsInOrder();
        int i = 0;
        while (i < cols.length) {
            if (cols[i].getColumnGroup() == this) {
                if (cols[i].isVisible()) {
                    if (!foundFirstColumnInGroup) {
                        bounds.x = this.parent.getOrigin((GridColumn)cols[i], null).x;
                        foundFirstColumnInGroup = true;
                    }
                    bounds.width += cols[i].getWidth();
                }
            } else if (foundFirstColumnInGroup) break;
            ++i;
        }
        return bounds;
    }

    public void setHeaderWordWrap(boolean wordWrap) {
        this.checkWidget();
        this.headerRenderer.setWordWrap(wordWrap);
        this.parent.redraw();
    }

    public boolean getHeaderWordWrap() {
        this.checkWidget();
        return this.headerRenderer.isWordWrap();
    }

    public Font getHeaderFont() {
        this.checkWidget();
        if (this.headerFont == null) {
            return this.parent.getFont();
        }
        return this.headerFont;
    }

    public void setHeaderFont(Font font) {
        this.checkWidget();
        this.headerFont = font;
    }

    public int getAlignment() {
        this.checkWidget();
        return this.headerRenderer.getHorizontalAlignment();
    }
}

