/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw.transitions;

import org.eclipse.nebula.effects.stw.Transition;
import org.eclipse.nebula.effects.stw.TransitionManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class SlideTransition
extends Transition {
    private int _w;
    private int _halfW;
    private int _h;
    private int _halfH;
    private double _a;
    private double _x;
    private double _y;
    private double _x0;
    private double _y0;
    private double _v0;
    private boolean _flag1;
    private ImageData _fromData;
    private long _halfT;
    private long _t1;

    public SlideTransition(TransitionManager transitionManager) {
        this(transitionManager, 60L, 1000L);
    }

    public SlideTransition(TransitionManager transitionManager, long fps, long T) {
        super(transitionManager, fps, T);
    }

    @Override
    protected void initTransition(Image from, Image to, GC gc, double direction) {
        this._halfT = (long)((double)this._T / 2.0);
        this._fromData = from.getImageData();
        switch ((int)direction) {
            case 0: 
            case 180: {
                this._w = this._fromData.width;
                this._halfW = (int)((double)this._w / 2.0);
                this._a = (double)this._w / (double)(this._halfT * this._halfT);
                this._x = 0.0;
                break;
            }
            case 90: 
            case 270: {
                this._h = this._fromData.height;
                this._halfH = (int)((double)this._h / 2.0);
                this._a = (double)this._h / (double)(this._halfT * this._halfT);
                this._y = 0.0;
            }
        }
        this._flag1 = false;
    }

    @Override
    protected void stepTransition(long t, Image from, Image to, GC gc, double direction) {
        switch ((int)direction) {
            case 0: {
                gc.drawImage(from, (int)this._x, 0);
                gc.drawImage(to, (int)(this._x - (double)this._w), 0);
                if (t <= this._halfT) {
                    this._x = Math.min(0.5 * this._a * (double)t * (double)t, (double)this._halfW);
                    break;
                }
                if (!this._flag1) {
                    this._x0 = this._x;
                    this._v0 = this._a * (double)t;
                    this._a *= -1.0;
                    this._flag1 = true;
                }
                this._t1 = t - this._halfT;
                this._x = Math.min(this._x0 + this._v0 * (double)this._t1 + 0.5 * this._a * (double)this._t1 * (double)this._t1, (double)this._w);
                break;
            }
            case 180: {
                gc.drawImage(from, (int)this._x, 0);
                gc.drawImage(to, (int)(this._x + (double)this._w), 0);
                if (t <= this._halfT) {
                    this._x = Math.max(-0.5 * this._a * (double)t * (double)t, (double)(-this._halfW));
                    break;
                }
                if (!this._flag1) {
                    this._x0 = this._x;
                    this._v0 = this._a * (double)t;
                    this._a *= -1.0;
                    this._flag1 = true;
                }
                this._t1 = t - this._halfT;
                this._x = Math.max(this._x0 - this._v0 * (double)this._t1 - 0.5 * this._a * (double)this._t1 * (double)this._t1, (double)(-this._w));
                break;
            }
            case 90: {
                gc.drawImage(from, 0, (int)this._y);
                gc.drawImage(to, 0, (int)(this._y + (double)this._h));
                if (t <= this._halfT) {
                    this._y = Math.max(-0.5 * this._a * (double)t * (double)t, (double)(-this._halfH));
                    break;
                }
                if (!this._flag1) {
                    this._y0 = this._y;
                    this._v0 = this._a * (double)t;
                    this._a *= -1.0;
                    this._flag1 = true;
                }
                this._t1 = t - this._halfT;
                this._y = Math.max(this._y0 - this._v0 * (double)this._t1 - 0.5 * this._a * (double)this._t1 * (double)this._t1, (double)(-this._h));
                break;
            }
            case 270: {
                gc.drawImage(from, 0, (int)this._y);
                gc.drawImage(to, 0, (int)(this._y - (double)this._h));
                if (t <= this._halfT) {
                    this._y = Math.min(0.5 * this._a * (double)t * (double)t, (double)this._halfH);
                    break;
                }
                if (!this._flag1) {
                    this._y0 = this._y;
                    this._v0 = this._a * (double)t;
                    this._a *= -1.0;
                    this._flag1 = true;
                }
                this._t1 = t - this._halfT;
                this._y = Math.min(this._y0 + this._v0 * (double)this._t1 + 0.5 * this._a * (double)this._t1 * (double)this._t1, (double)this._h);
            }
        }
    }

    @Override
    protected void endTransition(Image from, Image to, GC gc, double direction) {
    }
}

