/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.multichoice.snippets;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.nebula.widgets.opal.multichoice.MultiChoice;
import org.eclipse.nebula.widgets.opal.multichoice.MultiChoiceSelectionListener;
import org.eclipse.nebula.widgets.opal.multichoice.snippets.Country;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class MultiChoiceSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(4, false));
        shell.setText("MultiChoice Example");
        Object[] euroZone = new String[]{"Austria", "Belgium", "Cyprus", "Estonia", "Finland", "France", "Germany", "Greece", "Ireland", "Italy", "Luxembourg", "Malta", "Netherlands", "Portugal", "Slovakia", "Slovenia", "Spain"};
        ArrayList<Country> membersOfEuropeanUnion = new ArrayList<Country>();
        membersOfEuropeanUnion.add(new Country("Austria", 8372930));
        membersOfEuropeanUnion.add(new Country("Belgium", 10827519));
        membersOfEuropeanUnion.add(new Country("Bulgaria", 7576751));
        membersOfEuropeanUnion.add(new Country("Cyprus", 801851));
        membersOfEuropeanUnion.add(new Country("Czech Republic", 10512397));
        membersOfEuropeanUnion.add(new Country("Denmark", 5547088));
        membersOfEuropeanUnion.add(new Country("Estonia", 1340274));
        membersOfEuropeanUnion.add(new Country("Finland", 5530575));
        membersOfEuropeanUnion.add(new Country("France", 64709480));
        membersOfEuropeanUnion.add(new Country("Germany", 81757595));
        membersOfEuropeanUnion.add(new Country("Greece", 11125179));
        membersOfEuropeanUnion.add(new Country("Hungary", 10013628));
        membersOfEuropeanUnion.add(new Country("Ireland", 4450878));
        membersOfEuropeanUnion.add(new Country("Italy", 60397353));
        membersOfEuropeanUnion.add(new Country("Latvia", 2248961));
        membersOfEuropeanUnion.add(new Country("Lithuania", 3329227));
        membersOfEuropeanUnion.add(new Country("Luxembourg", 502207));
        membersOfEuropeanUnion.add(new Country("Malta", 416333));
        membersOfEuropeanUnion.add(new Country("Netherlands", 16576800));
        membersOfEuropeanUnion.add(new Country("Poland", 38163895));
        membersOfEuropeanUnion.add(new Country("Portugal", 11317192));
        membersOfEuropeanUnion.add(new Country("Romania", 21466174));
        membersOfEuropeanUnion.add(new Country("Slovakia", 5424057));
        membersOfEuropeanUnion.add(new Country("Slovenia", 2054119));
        membersOfEuropeanUnion.add(new Country("Spain", 46087170));
        membersOfEuropeanUnion.add(new Country("Sweden", 9347899));
        membersOfEuropeanUnion.add(new Country("United Kingdom", 62041708));
        ArrayList<Country> membersOfEUSelectAll = new ArrayList<Country>();
        membersOfEUSelectAll.addAll(membersOfEuropeanUnion);
        membersOfEUSelectAll.add(new Country("Select All", -1));
        ArrayList<Country> countryCodes = new ArrayList<Country>();
        countryCodes.add(new Country("France", "FR"));
        countryCodes.add(new Country("United states", "US"));
        countryCodes.add(new Country("United Kingdom", "UK"));
        countryCodes.add(new Country("Germany", "DE"));
        countryCodes.add(new Country("Belgium", "BE"));
        countryCodes.add(new Country("Netherland", "NL"));
        countryCodes.add(new Country("Italy", "IT"));
        countryCodes.add(new Country("Spain", "ES"));
        countryCodes.add(new Country("Portugal", "PT"));
        MultiChoiceSnippet.drawLabel(shell, "Simple Multichoice :");
        MultiChoice mcSimple = new MultiChoice((Composite)shell, 8);
        mcSimple.setEditable(false);
        GridData gridData = new GridData(4, 1, true, true);
        gridData.widthHint = 200;
        mcSimple.setLayoutData((Object)gridData);
        mcSimple.addAll(euroZone);
        MultiChoiceSnippet.addButons(mcSimple);
        MultiChoiceSnippet.drawLabel(shell, "Simple Multichoice with select/deselect all links:");
        MultiChoice mcSelectDeselectAll = new MultiChoice((Composite)shell, 8);
        mcSelectDeselectAll.setEditable(false);
        mcSelectDeselectAll.setShowSelectUnselectAll(true);
        GridData gridDataSelectDeselectAll = new GridData(4, 1, true, true);
        gridDataSelectDeselectAll.widthHint = 200;
        mcSelectDeselectAll.setLayoutData((Object)gridDataSelectDeselectAll);
        mcSelectDeselectAll.addAll(euroZone);
        MultiChoiceSnippet.addButons(mcSelectDeselectAll);
        MultiChoiceSnippet.drawLabel(shell, "Multichoice with beans :");
        MultiChoice mcBeans = new MultiChoice((Composite)shell, 8);
        mcBeans.setLayoutData((Object)new GridData(4, 1, true, true));
        mcBeans.addAll(membersOfEuropeanUnion);
        mcBeans.setText("Non european country");
        MultiChoiceSnippet.addButons(mcBeans);
        MultiChoiceSnippet.drawLabel(shell, "Selection listener :");
        MultiChoice mcSL = new MultiChoice((Composite)shell, 8);
        mcSL.setLayoutData((Object)new GridData(4, 1, true, true));
        mcSL.setSelectionListener((MultiChoiceSelectionListener)new MultiChoiceSelectionListener<Country>(mcSL){

            public void handle(MultiChoice<Country> parent, Country receiver, boolean selection, Shell popup) {
                if ("Select All".equals(receiver.toString())) {
                    if (selection) {
                        parent.deselectAll();
                        parent.selectAll();
                    } else {
                        parent.deselectAll();
                    }
                    popup.setVisible(false);
                }
            }
        });
        mcSL.addAll(membersOfEUSelectAll);
        MultiChoiceSnippet.addButons(mcSL);
        MultiChoiceSnippet.drawLabel(shell, "3 columns :");
        MultiChoice mc3Columns = new MultiChoice((Composite)shell, 8);
        mc3Columns.setLayoutData((Object)new GridData(4, 1, true, true));
        mc3Columns.addAll(euroZone);
        mc3Columns.setNumberOfColumns(3);
        MultiChoiceSnippet.addButons(mc3Columns);
        MultiChoiceSnippet.drawLabel(shell, "Other separator :");
        MultiChoice mcOtherSeparator = new MultiChoice((Composite)shell, 8);
        mcOtherSeparator.setLayoutData((Object)new GridData(4, 1, true, true));
        mcOtherSeparator.addAll(euroZone);
        mcOtherSeparator.setSeparator(" - ");
        MultiChoiceSnippet.addButons(mcOtherSeparator);
        MultiChoiceSnippet.drawLabel(shell, "Modifiable combo :");
        MultiChoice mcModify = new MultiChoice((Composite)shell, 0);
        mcModify.setLayoutData((Object)new GridData(4, 1, true, true));
        mcModify.setLabelProvider(element -> {
            if (element == null || !(element instanceof Country)) {
                return "";
            }
            return ((Country)element).getCode();
        });
        mcModify.addAll(countryCodes);
        MultiChoiceSnippet.addButons(mcModify);
        MultiChoiceSnippet.drawLabel(shell, "Lot of data :");
        ArrayList<CallSite> data = new ArrayList<CallSite>();
        int i = 0;
        while (i < 1000) {
            data.add((CallSite)((Object)("Data #" + i)));
            ++i;
        }
        MultiChoice mcLotOfData = new MultiChoice((Composite)shell, 0);
        mcLotOfData.setLayoutData((Object)new GridData(4, 1, true, true));
        mcLotOfData.setLabelProvider(element -> {
            if (element == null) {
                return "";
            }
            return (String)element;
        });
        mcLotOfData.addAll(data);
        MultiChoiceSnippet.addButons(mcLotOfData);
        MultiChoiceSnippet.drawLabel(shell, "Non Editable Multichoice :");
        MultiChoice mcNotEditable = new MultiChoice((Composite)shell, 8);
        GridData gridDataNotEditable = new GridData(4, 1, true, true);
        gridDataNotEditable.widthHint = 200;
        mcNotEditable.setLayoutData((Object)gridDataNotEditable);
        mcNotEditable.addAll(euroZone);
        mcNotEditable.setEditable(false);
        MultiChoiceSnippet.addButons(mcNotEditable);
        MultiChoiceSnippet.drawLabel(shell, "Not Enabled Multichoice :");
        MultiChoice mcNotEnabled = new MultiChoice((Composite)shell, 8);
        GridData gridDataNotEnabled = new GridData(4, 1, true, true);
        gridDataNotEnabled.widthHint = 200;
        mcNotEnabled.setLayoutData((Object)gridDataNotEnabled);
        mcNotEnabled.addAll(euroZone);
        mcNotEnabled.setEditable(false);
        MultiChoiceSnippet.addButons(mcNotEnabled);
        MultiChoiceSnippet.drawLabel(shell, "Multichoice with search panel :");
        MultiChoice mcSearch = new MultiChoice((Composite)shell, 136);
        mcSearch.setEditable(false);
        GridData gridDataMcSearch = new GridData(4, 1, true, true);
        gridDataMcSearch.widthHint = 200;
        mcSearch.setLayoutData((Object)gridDataMcSearch);
        mcSearch.addAll(euroZone);
        MultiChoiceSnippet.addButons(mcSearch);
        shell.open();
        shell.pack();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void drawLabel(Shell shell, String text) {
        Label label = new Label((Composite)shell, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(1, 1, false, false));
    }

    private static void addButons(MultiChoice<?> mc) {
        Button buttonShowSelection = new Button(mc.getParent(), 8);
        buttonShowSelection.setLayoutData((Object)new GridData(1, 1, false, false));
        buttonShowSelection.setText("Show selection");
        buttonShowSelection.addListener(13, e -> {
            Iterator it = mc.getSelection().iterator();
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                sb.append(it.next().toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            MessageBox mb = new MessageBox(mc.getShell(), 32);
            mb.setMessage(sb.toString());
            mb.open();
        });
        Button buttonShowSelectedIndex = new Button(mc.getParent(), 8);
        buttonShowSelectedIndex.setLayoutData((Object)new GridData(1, 1, false, false));
        buttonShowSelectedIndex.setText("Show selected index");
        buttonShowSelectedIndex.addListener(13, e -> {
            StringBuilder sb = new StringBuilder();
            int[] selectedIndex = mc.getSelectedIndex();
            if (selectedIndex.length > 0) {
                sb.append(selectedIndex[0]);
                int i = 1;
                while (i < selectedIndex.length) {
                    sb.append(",");
                    sb.append(selectedIndex[i]);
                    ++i;
                }
            } else {
                sb.append("Empty");
            }
            MessageBox mb = new MessageBox(mc.getShell(), 32);
            mb.setMessage(sb.toString());
            mb.open();
        });
    }
}

