/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.passwordrevealer;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.passwordrevealer.PasswordRevealer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

class EyeButton
extends Canvas {
    private static final int CIRCLE_RAY = 4;
    private boolean mouseIn;
    private boolean pressed;
    private final Color color;
    private Image image;
    private Image clickImage;
    private boolean isPushMode;
    private boolean pushState;

    EyeButton(Composite parent, int style) {
        super(parent, 0x20000000);
        this.isPushMode = (style & 8) == 8;
        this.addListeners();
        this.color = new Color((Device)parent.getDisplay(), 0, 127, 222);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource[])new Resource[]{this.color});
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.pushState = false;
    }

    private void addListeners() {
        this.addPaintListener(e -> this.paintControl(e));
        this.addListener(6, event -> {
            this.mouseIn = true;
            this.redraw();
        });
        this.addListener(7, event -> {
            this.mouseIn = false;
            this.pressed = false;
            this.redraw();
        });
        this.addListener(3, event -> {
            if (this.isPushMode) {
                return;
            }
            this.pressed = true;
            ((PasswordRevealer)this.getParent()).revealPassword();
            this.redraw();
        });
        this.addListener(4, event -> {
            if (this.isPushMode) {
                boolean bl = this.pushState = !this.pushState;
                if (this.pushState) {
                    ((PasswordRevealer)this.getParent()).revealPassword();
                } else {
                    ((PasswordRevealer)this.getParent()).hidePassword();
                }
                return;
            }
            this.pressed = false;
            ((PasswordRevealer)this.getParent()).hidePassword();
            this.redraw();
        });
    }

    private void paintControl(PaintEvent e) {
        GC gc = e.gc;
        if (!this.mouseIn && !this.pressed) {
            if (this.image != null) {
                this.drawImage(gc, this.image);
            } else {
                this.drawEye(gc, this.getDisplay().getSystemColor(15));
            }
            return;
        }
        if (this.mouseIn && !this.pressed) {
            if (this.image != null) {
                this.drawImage(gc, this.image);
            } else {
                this.drawEye(gc, this.color);
            }
            return;
        }
        if (this.clickImage == null && this.image != null) {
            this.drawImage(gc, this.image);
            return;
        }
        if (this.clickImage != null) {
            this.drawImage(gc, this.clickImage);
            return;
        }
        Rectangle rect = this.getClientArea();
        gc.setBackground(this.color);
        gc.fillRectangle(rect);
        this.drawEye(gc, this.getDisplay().getSystemColor(1));
    }

    private void drawEye(GC gc, Color clr) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setLineWidth(2);
        Rectangle rect = this.getClientArea();
        int eyeWidth = (int)((double)rect.width * 0.7);
        int eyeHeight = (int)((double)rect.height * 0.5);
        gc.setForeground(clr);
        gc.drawOval((int)((double)rect.width * 0.15), (int)((double)rect.height * 0.25), eyeWidth, eyeHeight);
        gc.setBackground(clr);
        gc.fillOval(rect.width / 2 - 2, rect.height / 2 - 2, 4, 4);
    }

    private void drawImage(GC gc, Image img) {
        Rectangle rect = this.getClientArea();
        Rectangle imageBounds = img.getBounds();
        int middleX = (rect.width - imageBounds.width) / 2;
        int middleY = (rect.height - imageBounds.height) / 2;
        gc.drawImage(img, middleX, middleY);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int minWidth;
        int minHeight;
        PasswordRevealer parent = (PasswordRevealer)this.getParent();
        int preferred = parent.passwordField.computeSize((int)-1, (int)hHint, (boolean)changed).y;
        if (this.image == null) {
            minHeight = 20;
            minWidth = 20;
        } else {
            minWidth = this.image.getBounds().width;
            minHeight = this.image.getBounds().height;
            if (this.clickImage != null) {
                minWidth = Math.max(this.clickImage.getBounds().width, minWidth);
                minHeight = Math.max(this.clickImage.getBounds().height, minHeight);
            }
        }
        return super.computeSize(Math.max(preferred, minWidth), Math.max(preferred, minHeight), changed);
    }

    void setImage(Image image) {
        this.image = image;
    }

    void setClickImage(Image clickImage) {
        this.clickImage = clickImage;
    }

    Image getImage() {
        return this.image;
    }

    Image getClickImage() {
        return this.clickImage;
    }

    void setPushMode(boolean pushMode) {
        this.isPushMode = pushMode;
    }
}

