/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ctreecombo.viewer;

import java.util.LinkedList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.widgets.ctreecombo.CTreeCombo;
import org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class CTreeComboViewerRow
extends ViewerRow {
    private CTreeComboItem item;

    CTreeComboViewerRow(CTreeComboItem item) {
        this.item = item;
    }

    public Rectangle getBounds(int columnIndex) {
        return this.item.getBounds(columnIndex);
    }

    public Rectangle getBounds() {
        return this.item.getBounds();
    }

    public int getColumnCount() {
        return this.item.getParent().getColumnCount();
    }

    public Widget getItem() {
        return this.item;
    }

    public Color getBackground(int columnIndex) {
        return this.item.getBackground(columnIndex);
    }

    public Font getFont(int columnIndex) {
        return this.item.getFont(columnIndex);
    }

    public Color getForeground(int columnIndex) {
        return this.item.getForeground(columnIndex);
    }

    public Image getImage(int columnIndex) {
        return this.item.getImage(columnIndex);
    }

    public String getText(int columnIndex) {
        return this.item.getText(columnIndex);
    }

    public void setBackground(int columnIndex, Color color) {
        this.item.setBackground(columnIndex, color);
    }

    public void setFont(int columnIndex, Font font) {
        this.item.setFont(columnIndex, font);
    }

    public void setForeground(int columnIndex, Color color) {
        this.item.setForeground(columnIndex, color);
    }

    public void setImage(int columnIndex, Image image) {
        Image oldImage = this.item.getImage(columnIndex);
        if (image != oldImage) {
            this.item.setImage(columnIndex, image);
        }
    }

    public void setText(int columnIndex, String text) {
        this.item.setText(columnIndex, text == null ? "" : text);
    }

    public Control getControl() {
        return this.item.getParent();
    }

    public ViewerRow getNeighbor(int direction, boolean sameLevel) {
        if (direction == 1) {
            return this.getRowAbove(sameLevel);
        }
        if (direction == 2) {
            return this.getRowBelow(sameLevel);
        }
        throw new IllegalArgumentException("Illegal value of direction argument.");
    }

    private ViewerRow getRowBelow(boolean sameLevel) {
        CTreeCombo tree = this.item.getParent();
        if (this.item.getParentItem() == null) {
            if (sameLevel || !this.item.getExpanded()) {
                int index = tree.indexOf(this.item) + 1;
                if (index < tree.getItemCount()) {
                    return new CTreeComboViewerRow(tree.getItem(index));
                }
            } else if (this.item.getExpanded() && this.item.getItemCount() > 0) {
                return new CTreeComboViewerRow(this.item.getItem(0));
            }
        } else if (sameLevel || !this.item.getExpanded()) {
            int totalIndex;
            CTreeComboItem parentItem = this.item.getParentItem();
            int nextIndex = parentItem.indexOf(this.item) + 1;
            CTreeComboItem itemAfter = nextIndex == (totalIndex = parentItem.getItemCount()) ? this.findNextItem(parentItem) : parentItem.getItem(nextIndex);
            if (itemAfter != null) {
                return new CTreeComboViewerRow(itemAfter);
            }
        } else if (this.item.getExpanded() && this.item.getItemCount() > 0) {
            return new CTreeComboViewerRow(this.item.getItem(0));
        }
        return null;
    }

    private ViewerRow getRowAbove(boolean sameLevel) {
        CTreeCombo tree = this.item.getParent();
        if (this.item.getParentItem() == null) {
            int index = tree.indexOf(this.item) - 1;
            CTreeComboItem nextTopItem = null;
            if (index >= 0) {
                nextTopItem = tree.getItem(index);
            }
            if (nextTopItem != null) {
                if (sameLevel) {
                    return new CTreeComboViewerRow(nextTopItem);
                }
                return new CTreeComboViewerRow(this.findLastVisibleItem(nextTopItem));
            }
        } else {
            CTreeComboItem parentItem = this.item.getParentItem();
            int previousIndex = parentItem.indexOf(this.item) - 1;
            CTreeComboItem itemBefore = previousIndex >= 0 ? (sameLevel ? parentItem.getItem(previousIndex) : this.findLastVisibleItem(parentItem.getItem(previousIndex))) : parentItem;
            if (itemBefore != null) {
                return new CTreeComboViewerRow(itemBefore);
            }
        }
        return null;
    }

    private CTreeComboItem findLastVisibleItem(CTreeComboItem parentItem) {
        CTreeComboItem rv = parentItem;
        while (rv.getExpanded() && rv.getItemCount() > 0) {
            rv = rv.getItem(rv.getItemCount() - 1);
        }
        return rv;
    }

    private CTreeComboItem findNextItem(CTreeComboItem item) {
        int totalItems;
        int nextIndex;
        CTreeComboItem rv = null;
        CTreeCombo tree = item.getParent();
        CTreeComboItem parentItem = item.getParentItem();
        if (parentItem == null) {
            nextIndex = tree.indexOf(item) + 1;
            totalItems = tree.getItemCount();
        } else {
            nextIndex = parentItem.indexOf(item) + 1;
            totalItems = parentItem.getItemCount();
        }
        if (nextIndex == totalItems) {
            if (item.getParentItem() != null) {
                rv = this.findNextItem(item.getParentItem());
            }
        } else {
            rv = parentItem == null ? tree.getItem(nextIndex) : parentItem.getItem(nextIndex);
        }
        return rv;
    }

    public TreePath getTreePath() {
        CTreeComboItem tItem = this.item;
        LinkedList<Object> segments = new LinkedList<Object>();
        while (tItem != null) {
            Object segment = tItem.getData();
            Assert.isNotNull((Object)segment);
            segments.addFirst(segment);
            tItem = tItem.getParentItem();
        }
        return new TreePath(segments.toArray());
    }

    void setItem(CTreeComboItem item) {
        this.item = item;
    }

    public Object clone() {
        return new CTreeComboViewerRow(this.item);
    }

    public Object getElement() {
        return this.item.getData();
    }

    public int getVisualIndex(int creationIndex) {
        int[] order = this.item.getParent().getColumnOrder();
        int i = 0;
        while (i < order.length) {
            if (order[i] == creationIndex) {
                return i;
            }
            ++i;
        }
        return super.getVisualIndex(creationIndex);
    }

    public int getCreationIndex(int visualIndex) {
        if (this.item != null && !this.item.isDisposed() && this.hasColumns() && this.isValidOrderIndex(visualIndex)) {
            return this.item.getParent().getColumnOrder()[visualIndex];
        }
        return super.getCreationIndex(visualIndex);
    }

    public Rectangle getTextBounds(int index) {
        return this.item.getTextBounds(index);
    }

    public Rectangle getImageBounds(int index) {
        return this.item.getImageBounds(index);
    }

    private boolean hasColumns() {
        return this.item.getParent().getColumnCount() != 0;
    }

    private boolean isValidOrderIndex(int currentIndex) {
        return currentIndex < this.item.getParent().getColumnOrder().length;
    }
}

