/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.core.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.xviewer.core.model.ColumnData;
import org.eclipse.nebula.widgets.xviewer.core.model.ColumnFilterData;
import org.eclipse.nebula.widgets.xviewer.core.model.FilterData;
import org.eclipse.nebula.widgets.xviewer.core.model.SortingData;
import org.eclipse.nebula.widgets.xviewer.core.util.XViewerUtil;

public class CustomizeData
implements Comparable<CustomizeData> {
    private String guid = XViewerUtil.generateGuidStr();
    private String name;
    private String nameSpace;
    private boolean personal = false;
    protected SortingData sortingData = new SortingData(this);
    protected FilterData filterData = new FilterData();
    protected ColumnFilterData columnFilterData = new ColumnFilterData();
    public static String TABLE_DEFAULT_LABEL = "-- Current Table View --";
    public static String CURRENT_LABEL = "-- Table Default --";
    protected ColumnData columnData = new ColumnData();
    private static Pattern pattern = Pattern.compile("name=\"(.*?)\".*?namespace=\"(.*?)\".*?guid=\"(.*?)\"");
    private static Pattern personalPattern = Pattern.compile("<personal>(.*?)</personal>");

    public ColumnFilterData getColumnFilterData() {
        return this.columnFilterData;
    }

    public CustomizeData() {
    }

    public boolean isTableDefaultCustData() {
        return this.name.equals(TABLE_DEFAULT_LABEL);
    }

    public boolean isCurrentTableCustData() {
        return this.name.equals(CURRENT_LABEL);
    }

    public CustomizeData(String xml) {
        this();
        this.setFromXml(xml);
    }

    public void resetGuid() {
        this.guid = XViewerUtil.generateGuidStr();
    }

    public String getXml(boolean visibleColumnsOnly) {
        StringBuilder sb = new StringBuilder("<XTreeProperties name=\"" + this.name + "\" namespace=\"" + this.nameSpace + "\" guid=\"" + this.guid + "\">");
        sb.append("<personal>");
        sb.append(this.personal);
        sb.append("</personal>");
        sb.append(this.sortingData.getXml());
        sb.append(this.filterData.getXml());
        sb.append(this.columnFilterData.getXml());
        sb.append(this.columnData.getXml(visibleColumnsOnly));
        sb.append("</XTreeProperties>");
        return sb.toString();
    }

    public void setFromXml(String xml) {
        Matcher m = pattern.matcher(xml);
        if (!m.find()) {
            String name2 = "Invalid customize format for " + xml.substring(0, 50);
            this.setName(name2);
            return;
        }
        this.setName(m.group(1));
        this.setNameSpace(m.group(2));
        this.guid = m.group(3);
        m = personalPattern.matcher(xml);
        if (m.find()) {
            this.personal = m.group(1).equals("true");
        }
        this.sortingData.setFromXml(xml);
        this.filterData.setFromXml(xml);
        this.columnData.setFromXml(xml);
        this.columnFilterData.setFromXml(xml);
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public ColumnData getColumnData() {
        return this.columnData;
    }

    public FilterData getFilterData() {
        return this.filterData;
    }

    public SortingData getSortingData() {
        return this.sortingData;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = XViewerUtil.intern(name);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = XViewerUtil.intern(nameSpace);
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public boolean equals(Object obj) {
        return obj instanceof CustomizeData && ((CustomizeData)obj).getGuid().equals(this.guid);
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    @Override
    public int compareTo(CustomizeData custData) {
        return this.getName().compareToIgnoreCase(custData.getName());
    }

    public String toString() {
        return "CustomizeData [guid=" + this.guid + ", name=" + this.name + ", nameSpace=" + this.nameSpace + ", personal=" + this.personal + ", \n\n" + String.valueOf(this.sortingData) + ", \n\n" + String.valueOf(this.filterData) + ", \n\n" + String.valueOf(this.columnFilterData) + ", \n\n" + String.valueOf(this.columnData) + "]";
    }
}

