/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.overview;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewSelectionFigure;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;
import org.eclipse.nebula.widgets.timeline.listeners.OverviewSelector;

public class OverviewSelectionLayer
extends FreeformLayer {
    private static final int MINIMUM_WIDTH = 5;

    public OverviewSelectionLayer(ITimelineStyleProvider styleProvider) {
        this.setLayoutManager((LayoutManager)new OverviewSelectionLayerLayout());
        this.add((IFigure)new OverviewSelectionFigure(styleProvider));
        new OverviewSelector((Figure)this);
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public boolean containsPoint(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    private class OverviewSelectionLayerLayout
    extends XYLayout {
        private OverviewSelectionLayerLayout() {
        }

        public Object getConstraint(IFigure figure) {
            TimeBaseConverter timeConverter = RootFigure.getTimeViewDetails(figure);
            Timing coordinates = timeConverter.toOverviewScreenCoordinates(timeConverter.getVisibleEventArea());
            PrecisionRectangle bounds = new PrecisionRectangle(coordinates.left(), 0.0, coordinates.getDuration(), (double)OverviewSelectionLayer.this.getBounds().height());
            if (bounds.width() < 5) {
                bounds.setWidth(5);
            }
            return bounds;
        }
    }
}

