/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.borders;

import org.eclipse.draw2d.AbstractLabeledBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class TrackBorder
extends AbstractLabeledBorder {
    private final Insets fTextPadding = new Insets(2, 50, 2, 0);
    private final Insets fLinePadding = new Insets(0, 8, 0, 8);

    public TrackBorder(String title) {
        super(title);
        this.setTextColor(ColorConstants.menuForegroundSelected);
    }

    protected Insets calculateInsets(IFigure figure) {
        if (this.getLabel().isEmpty()) {
            return new Insets(0);
        }
        return new Insets(this.getTextExtents((IFigure)figure).height + this.fTextPadding.getHeight(), 0, 0, 0);
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        if (!this.getLabel().isEmpty()) {
            Dimension textExtents = this.getTextExtents(figure);
            Rectangle area = figure.getBounds().getCopy();
            area.setWidth(figure.getParent().getBounds().width());
            area.setHeight(Math.min(area.height, textExtents.height + this.fTextPadding.getHeight()));
            area.shrink(insets);
            g.clipRect(area);
            int y = area.y + area.height() / 2;
            g.setForegroundColor(ColorConstants.gray);
            g.drawLine(area.x + this.fLinePadding.left, y, area.x + this.fTextPadding.left - this.fLinePadding.left, y);
            g.drawLine(area.x + this.fTextPadding.left + textExtents.width + this.fLinePadding.left, y, area.x + area.width() - this.fLinePadding.right, y);
            g.setForegroundColor(ColorConstants.lightGray);
            g.drawLine(area.x + this.fLinePadding.left, ++y, area.x + this.fTextPadding.left - this.fLinePadding.left, y);
            g.drawLine(area.x + this.fTextPadding.left + textExtents.width + this.fLinePadding.left, y, area.x + area.width() - this.fLinePadding.right, y);
            int x = area.x + this.fTextPadding.left;
            y = area.y + this.fTextPadding.top;
            g.setFont(this.getFont(figure));
            g.setForegroundColor(this.getTextColor());
            g.drawString(this.getLabel(), x, y);
        }
    }
}

