/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.StringUtil;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidgetFactory;
import org.eclipse.nebula.widgets.opal.propertytable.PropertyTable;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractPTWidget
implements PTWidget {
    private PropertyTable parentPropertyTable;
    protected StyledText descriptionLabel;

    @Override
    public abstract void refillData();

    protected abstract void buildWidget(Composite var1);

    @Override
    public PTWidget build() {
        PropertyTable parent;
        SashForm form = null;
        if (this.parentPropertyTable.showDescription) {
            form = new SashForm((Composite)this.parentPropertyTable, 2560);
            form.setSashWidth(3);
            form.setLayout((Layout)new GridLayout());
            parent = new Composite((Composite)form, 0);
            parent.setLayoutData(new GridData(4, 4, true, true));
        } else {
            parent = this.parentPropertyTable;
        }
        parent.setLayout((Layout)new GridLayout(3, false));
        if (this.parentPropertyTable.showButtons) {
            this.buildButtons(parent, this.parentPropertyTable.sorted, this.parentPropertyTable.styleOfView == 1, this.parentPropertyTable.showDescription);
        }
        this.buildWidget(parent);
        if (this.parentPropertyTable.showDescription) {
            this.buildDescriptionPanel((Composite)form);
            form.setWeights(new int[]{90, 10});
        }
        return this;
    }

    private void buildButtons(Composite parent, boolean sorted, boolean showAsCategory, boolean showDescription) {
        this.buildSortButton(parent, sorted);
        this.buildCategoryButton(parent, showAsCategory);
        this.buildDescriptionButton(parent, showDescription);
    }

    private void buildSortButton(Composite parent, boolean sorted) {
        Button sortButton = new Button(parent, 0x800002);
        sortButton.setImage(SWTGraphicUtil.createImageFromFile((String)"images/sort.png"));
        sortButton.setSelection(sorted);
        sortButton.setToolTipText(ResourceManager.getLabel((String)"sort.shortDescription"));
        sortButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        sortButton.addListener(13, event -> {
            this.getParentPropertyTable().sorted = !this.getParentPropertyTable().sorted;
            this.refillData();
        });
    }

    private void buildCategoryButton(Composite parent, boolean showAsCategory) {
        Button categoryButton = new Button(parent, 0x800002);
        categoryButton.setImage(SWTGraphicUtil.createImageFromFile((String)"images/category.png"));
        categoryButton.setSelection(showAsCategory);
        categoryButton.setToolTipText(ResourceManager.getLabel((String)"category.shortDescription"));
        categoryButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        categoryButton.addListener(13, event -> {
            if (this.getParentPropertyTable().styleOfView == 1) {
                this.getParentPropertyTable().viewAsFlatList();
            } else {
                this.getParentPropertyTable().viewAsCategories();
            }
        });
    }

    private void buildDescriptionButton(Composite parent, boolean showDescription) {
        Button descriptionButton = new Button(parent, 0x800002);
        descriptionButton.setImage(SWTGraphicUtil.createImageFromFile((String)"images/description.png"));
        descriptionButton.setSelection(showDescription);
        descriptionButton.setToolTipText(ResourceManager.getLabel((String)"description.shortDescription"));
        descriptionButton.setLayoutData((Object)new GridData(1, 4, true, false, 1, 1));
        descriptionButton.addListener(13, event -> {
            if (this.getParentPropertyTable().showDescription) {
                this.getParentPropertyTable().hideDescription();
            } else {
                this.getParentPropertyTable().showDescription();
            }
        });
    }

    private void buildDescriptionPanel(Composite parent) {
        this.descriptionLabel = new StyledText(parent, 584);
        this.descriptionLabel.setText("");
        this.descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    @Override
    public PTWidget disposeAndBuild(PropertyTable table) {
        this.dispose();
        return PTWidgetFactory.build(table);
    }

    private void dispose() {
        if (this.parentPropertyTable == null || this.parentPropertyTable.getChildren() == null) {
            return;
        }
        Control[] controlArray = this.parentPropertyTable.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    protected PropertyTable getParentPropertyTable() {
        return this.parentPropertyTable;
    }

    @Override
    public void setParentPropertyTable(PropertyTable table) {
        this.parentPropertyTable = table;
    }

    @Override
    public void updateDescriptionPanel(Object selection) {
        if (selection == null || this.descriptionLabel == null) {
            return;
        }
        PTProperty selectedProperty = (PTProperty)selection;
        this.descriptionLabel.setText(StringUtil.safeToString((Object)selectedProperty.getDescription()));
        SWTGraphicUtil.applyHTMLFormating((StyledText)this.descriptionLabel);
        this.descriptionLabel.update();
    }
}

