/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable;

import org.eclipse.nebula.widgets.compositetable.InternalCompositeTable;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class EmptyTablePlaceholder
extends Canvas {
    private boolean focusControl = false;
    private InternalCompositeTable parentTable = null;
    private final Color RED;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            EmptyTablePlaceholder.this.removeTraverseListener(EmptyTablePlaceholder.this.traverseListener);
            EmptyTablePlaceholder.this.removeFocusListener(EmptyTablePlaceholder.this.focusListener);
            EmptyTablePlaceholder.this.removeKeyListener(EmptyTablePlaceholder.this.keyListener);
            EmptyTablePlaceholder.this.removePaintListener(EmptyTablePlaceholder.this.paintListener);
            EmptyTablePlaceholder.this.removeDisposeListener(EmptyTablePlaceholder.this.disposeListener);
            EmptyTablePlaceholder.this.getParent().removeControlListener(EmptyTablePlaceholder.this.controlListener);
        }
    };
    private ControlListener controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            EmptyTablePlaceholder.this.resize();
        }
    };
    private String message = "";
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Color oldColor = e.gc.getForeground();
            int oldLineStyle = e.gc.getLineStyle();
            int oldLineWidth = e.gc.getLineWidth();
            try {
                if (EmptyTablePlaceholder.this.focusControl) {
                    e.gc.setLineStyle(2);
                    e.gc.setLineWidth(2);
                    Point parentSize = EmptyTablePlaceholder.this.getSize();
                    e.gc.drawRectangle(1, 2, parentSize.x - 2, parentSize.y - 3);
                }
                e.gc.setForeground(EmptyTablePlaceholder.this.RED);
                e.gc.drawText(EmptyTablePlaceholder.this.getMessage(), 3, 3);
            }
            finally {
                e.gc.setForeground(oldColor);
                e.gc.setLineStyle(oldLineStyle);
                e.gc.setLineWidth(oldLineWidth);
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            EmptyTablePlaceholder.this.focusControl = true;
            EmptyTablePlaceholder.this.redraw();
        }

        public void focusLost(FocusEvent e) {
            EmptyTablePlaceholder.this.focusControl = false;
            EmptyTablePlaceholder.this.redraw();
        }
    };
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000009) {
                EmptyTablePlaceholder.this.parentTable.keyPressed(null, e);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };

    public EmptyTablePlaceholder(Composite parent, int style) {
        super(parent, style);
        this.parentTable = (InternalCompositeTable)parent.getParent().getParent();
        parent.addControlListener(this.controlListener);
        this.addTraverseListener(this.traverseListener);
        this.addFocusListener(this.focusListener);
        this.addKeyListener(this.keyListener);
        this.addPaintListener(this.paintListener);
        this.addDisposeListener(this.disposeListener);
        this.RED = Display.getCurrent().getSystemColor(3);
        this.setBackground(this.getParent().getBackground());
        this.resize();
    }

    private void resize() {
        Point headerSize = new Point(0, 0);
        Control header = this.parentTable.getHeaderControl();
        if (header != null) {
            headerSize = header.getSize();
        }
        Point parentSize = this.getParent().getSize();
        this.setBounds(0, headerSize.y + 2, parentSize.x - 4, parentSize.y - headerSize.y - 6);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.redraw();
    }
}

