/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.example;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewer;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.example.images.MyImageCache;
import org.eclipse.nebula.widgets.xviewer.example.model.ISomeTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class MyXViewerLabelProvider
extends XViewerLabelProvider {
    private final MyXViewer xViewerTest;

    public MyXViewerLabelProvider(MyXViewer xViewerTest) {
        super((XViewer)xViewerTest);
        this.xViewerTest = xViewerTest;
    }

    public String getColumnText(Object element, XViewerColumn xCol, int columnIndex) {
        if (element instanceof String) {
            if (columnIndex == 1) {
                return (String)element;
            }
            return "";
        }
        ISomeTask task = (ISomeTask)element;
        if (task == null) {
            return "";
        }
        if (xCol.equals((Object)MyXViewerFactory.Run_Col)) {
            return String.valueOf(this.xViewerTest.isRun(task));
        }
        if (xCol.equals((Object)MyXViewerFactory.Name_Col)) {
            return task.getId();
        }
        if (xCol.equals((Object)MyXViewerFactory.Schedule_Time)) {
            return task.getStartTime();
        }
        if (xCol.equals((Object)MyXViewerFactory.Run_Db)) {
            return task.getRunDb().name();
        }
        if (xCol.equals((Object)MyXViewerFactory.Task_Type)) {
            return task.getTaskType().name();
        }
        if (xCol.equals((Object)MyXViewerFactory.Description)) {
            return task.getDescription();
        }
        if (xCol.equals((Object)MyXViewerFactory.Category)) {
            return task.getCategory();
        }
        if (xCol.equals((Object)MyXViewerFactory.Notification)) {
            return task.getEmailAddress();
        }
        if (xCol.equals((Object)MyXViewerFactory.Last_Run_Date)) {
            return task.getLastRunDateStr();
        }
        if (xCol.equals((Object)MyXViewerFactory.Completed_Col)) {
            return String.valueOf(task.getPercentComplete());
        }
        if (xCol.equals((Object)MyXViewerFactory.Long_Column)) {
            return String.valueOf(task.getLongValue());
        }
        return "unhandled column";
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        if (xCol.equals((Object)MyXViewerFactory.Run_Col)) {
            return this.xViewerTest.isRun((ISomeTask)element) ? MyImageCache.getImage("chkbox_enabled.gif") : MyImageCache.getImage("chkbox_disabled.gif");
        }
        if (xCol.equals((Object)MyXViewerFactory.Name_Col) && this.xViewerTest.isScheduled((ISomeTask)element)) {
            return MyImageCache.getImage("clock.gif");
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return super.getBackground(element, columnIndex);
    }

    public int getColumnGradient(Object element, XViewerColumn xCol, int columnIndex) throws Exception {
        if (!(element instanceof ISomeTask)) {
            return 0;
        }
        ISomeTask task = (ISomeTask)element;
        if (xCol.equals((Object)MyXViewerFactory.Completed_Col)) {
            return task.getPercentComplete();
        }
        return 0;
    }
}

