/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.map.primitive;

import java.util.Set;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.ObjectObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ObjectFloatPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.map.primitive.FloatObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectFloatMap;
import org.eclipse.collections.api.tuple.primitive.ObjectFloatPair;

public interface ObjectFloatMap<K>
extends FloatIterable {
    public float get(Object var1);

    public float getOrThrow(Object var1);

    public float getIfAbsent(Object var1, float var2);

    public boolean containsKey(Object var1);

    public boolean containsValue(float var1);

    public void forEachValue(FloatProcedure var1);

    public void forEachKey(Procedure<? super K> var1);

    public void forEachKeyValue(ObjectFloatProcedure<? super K> var1);

    public FloatObjectMap<K> flipUniqueValues();

    default public boolean allSatisfyKeyValue(ObjectFloatPredicate<K> predicate) {
        for (ObjectFloatPair objectFloatPair : this.keyValuesView()) {
            if (predicate.accept(objectFloatPair.getOne(), objectFloatPair.getTwo())) continue;
            return false;
        }
        return true;
    }

    default public <IV> IV injectIntoKeyValue(IV injectedValue, ObjectObjectFloatToObjectFunction<? super IV, ? super K, ? extends IV> function) {
        Object[] result = new Object[]{injectedValue};
        this.forEachKeyValue((key, value) -> {
            result[0] = function.valueOf((Object)result[0], (Object)key, value);
        });
        return (IV)result[0];
    }

    public ObjectFloatMap<K> select(ObjectFloatPredicate<? super K> var1);

    public ObjectFloatMap<K> reject(ObjectFloatPredicate<? super K> var1);

    @Override
    default public ObjectFloatMap<K> tap(FloatProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public String toString();

    public ImmutableObjectFloatMap<K> toImmutable();

    public Set<K> keySet();

    public MutableFloatCollection values();

    public LazyIterable<K> keysView();

    public RichIterable<ObjectFloatPair<K>> keyValuesView();
}

