/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.blink;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.blink.BlinkConfigAttributes;
import org.eclipse.nebula.widgets.nattable.blink.CellKeyStrategyImpl;
import org.eclipse.nebula.widgets.nattable.blink.IBlinkingCellResolver;
import org.eclipse.nebula.widgets.nattable.blink.RowKeyStrategyImpl;
import org.eclipse.nebula.widgets.nattable.blink.UpdateEventsCache;
import org.eclipse.nebula.widgets.nattable.blink.command.BlinkTimerEnableCommandHandler;
import org.eclipse.nebula.widgets.nattable.blink.event.BlinkEvent;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.PropertyUpdateEvent;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.widgets.Display;

public class BlinkLayer<T>
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private final IUniqueIndexLayer dataLayer;
    private final IRowDataProvider<T> rowDataProvider;
    private final IConfigRegistry configRegistry;
    private final IRowIdAccessor<T> rowIdAccessor;
    private final IColumnPropertyResolver columnPropertyResolver;
    private final ScheduledExecutorService scheduler;
    protected boolean blinkingEnabled = true;
    private final UpdateEventsCache<T> updateEventsCache;
    private int blinkDurationInMilis = 1000;
    Map<String, PropertyUpdateEvent<T>> blinkingUpdates = new HashMap<String, PropertyUpdateEvent<T>>();
    Map<String, ScheduledFuture<?>> blinkingTasks = new HashMap();

    public BlinkLayer(IUniqueIndexLayer dataLayer, IRowDataProvider<T> listDataProvider, IRowIdAccessor<T> rowIdAccessor, IColumnPropertyResolver columnPropertyResolver, IConfigRegistry configRegistry) {
        this(dataLayer, listDataProvider, rowIdAccessor, columnPropertyResolver, configRegistry, false);
    }

    public BlinkLayer(IUniqueIndexLayer dataLayer, IRowDataProvider<T> listDataProvider, IRowIdAccessor<T> rowIdAccessor, IColumnPropertyResolver columnPropertyResolver, IConfigRegistry configRegistry, boolean triggerBlinkOnRowUpdate) {
        this(dataLayer, listDataProvider, rowIdAccessor, columnPropertyResolver, configRegistry, triggerBlinkOnRowUpdate, Executors.newSingleThreadScheduledExecutor());
    }

    public BlinkLayer(IUniqueIndexLayer dataLayer, IRowDataProvider<T> listDataProvider, IRowIdAccessor<T> rowIdAccessor, IColumnPropertyResolver columnPropertyResolver, IConfigRegistry configRegistry, boolean triggerBlinkOnRowUpdate, ScheduledExecutorService scheduler) {
        super(dataLayer);
        this.dataLayer = dataLayer;
        this.rowDataProvider = listDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.columnPropertyResolver = columnPropertyResolver;
        this.configRegistry = configRegistry;
        this.scheduler = scheduler;
        this.updateEventsCache = new UpdateEventsCache<T>(rowIdAccessor, triggerBlinkOnRowUpdate ? new RowKeyStrategyImpl() : new CellKeyStrategyImpl(), scheduler);
        this.registerCommandHandler(new BlinkTimerEnableCommandHandler(this));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.scheduler.shutdown();
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        if (!this.blinkingEnabled) {
            return this.getUnderlyingLayer().getConfigLabelsByPosition(columnPosition, rowPosition);
        }
        ILayerCell cell = this.underlyingLayer.getCellByPosition(columnPosition, rowPosition);
        int columnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(columnPosition);
        String columnProperty = this.columnPropertyResolver.getColumnProperty(columnIndex);
        int rowIndex = this.getUnderlyingLayer().getRowIndexByPosition(rowPosition);
        String rowId = this.rowIdAccessor.getRowId(this.rowDataProvider.getRowObject(rowIndex)).toString();
        String key = this.updateEventsCache.getKey(columnProperty, rowId);
        LabelStack underlyingLabelStack = this.getUnderlyingLayer().getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.updateEventsCache.isUpdated(key)) {
            LabelStack blinkingConfigTypes;
            PropertyUpdateEvent<T> event = this.updateEventsCache.getEvent(key);
            ScheduledFuture<?> scheduledFuture = this.blinkingTasks.remove(key);
            this.blinkingUpdates.remove(key);
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            if ((blinkingConfigTypes = this.resolveConfigTypes(cell, event.getOldValue(), event.getNewValue())) != null) {
                Runnable stopBlinkTask = this.getStopBlinkTask(key, this);
                this.blinkingUpdates.put(key, event);
                this.updateEventsCache.remove(key);
                this.blinkingTasks.put(key, this.scheduler.schedule(stopBlinkTask, (long)this.blinkDurationInMilis, TimeUnit.MILLISECONDS));
                return blinkingConfigTypes;
            }
            return underlyingLabelStack;
        }
        if (this.blinkingUpdates.containsKey(key)) {
            PropertyUpdateEvent<T> event = this.blinkingUpdates.get(key);
            return this.resolveConfigTypes(cell, event.getOldValue(), event.getNewValue());
        }
        return underlyingLabelStack;
    }

    public LabelStack resolveConfigTypes(ILayerCell cell, Object oldValue, Object newValue) {
        LabelStack underlyingLabelStack = this.underlyingLayer.getConfigLabelsByPosition(cell.getColumnIndex(), cell.getRowIndex());
        IBlinkingCellResolver resolver = this.configRegistry.getConfigAttribute(BlinkConfigAttributes.BLINK_RESOLVER, DisplayMode.NORMAL, (List<String>)underlyingLabelStack);
        String[] blinkConfigTypes = null;
        if (resolver != null) {
            blinkConfigTypes = resolver.resolve(cell, this.configRegistry, oldValue, newValue);
        }
        if (blinkConfigTypes != null && blinkConfigTypes.length > 0) {
            String[] stringArray = blinkConfigTypes;
            int n = blinkConfigTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String configType = stringArray[n2];
                underlyingLabelStack.addLabelOnTop(configType);
                ++n2;
            }
        }
        return underlyingLabelStack;
    }

    private Runnable getStopBlinkTask(String key, ILayer layer) {
        return () -> Display.getDefault().asyncExec(() -> {
            this.blinkingUpdates.remove(key);
            this.blinkingTasks.remove(key);
            this.fireLayerEvent(new BlinkEvent(layer));
        });
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (this.blinkingEnabled && event instanceof PropertyUpdateEvent) {
            this.updateEventsCache.put((PropertyUpdateEvent)event);
        }
        super.handleLayerEvent(event);
    }

    public void setBlinkingEnabled(boolean enabled) {
        this.blinkingEnabled = enabled;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.dataLayer.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.dataLayer.getRowPositionByIndex(rowIndex);
    }

    public void setBlinkDurationInMilis(int blinkDurationInMilis) {
        this.blinkDurationInMilis = blinkDurationInMilis;
    }
}

