/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.strategy;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.search.SearchDirection;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.CellDisplayValueSearchUtil;

public class RowSearchStrategy
extends AbstractSearchStrategy {
    private int[] rowPositions;
    private int startingColumnPosition;
    private final IConfigRegistry configRegistry;

    public RowSearchStrategy(int[] rowPositions, IConfigRegistry configRegistry) {
        this(rowPositions, 0, configRegistry, SearchDirection.SEARCH_FORWARD);
    }

    @Deprecated
    public RowSearchStrategy(int[] rowPositions, int startingColumnPosition, IConfigRegistry configRegistry, String searchDirection) {
        this(rowPositions, startingColumnPosition, configRegistry, SearchDirection.valueOf(searchDirection));
    }

    public RowSearchStrategy(int[] rowPositions, int startingColumnPosition, IConfigRegistry configRegistry, SearchDirection searchDirection) {
        this.rowPositions = rowPositions;
        this.startingColumnPosition = startingColumnPosition;
        this.configRegistry = configRegistry;
        this.searchDirection = searchDirection;
    }

    @Override
    public PositionCoordinate executeSearch(Object valueToMatch) {
        Comparator<String> comparator = this.getComparator();
        return CellDisplayValueSearchUtil.findCell(this.getContextLayer(), this.configRegistry, this.getRowCellsToSearch(this.getContextLayer()), valueToMatch, comparator, this.isCaseSensitive(), this.isWholeWord(), this.isRegex(), this.isIncludeCollapsed());
    }

    public void setStartingColumnPosition(int startingColumnPosition) {
        this.startingColumnPosition = startingColumnPosition;
    }

    public void setRowPositions(int[] rowPositions) {
        this.rowPositions = rowPositions;
    }

    protected PositionCoordinate[] getRowCellsToSearch(ILayer contextLayer) {
        ArrayList<PositionCoordinate> cellsToSearch = new ArrayList<PositionCoordinate>();
        int columnPosition = this.startingColumnPosition;
        int columnCount = contextLayer.getColumnCount();
        int width = this.searchDirection.equals((Object)SearchDirection.SEARCH_FORWARD) ? columnCount - this.startingColumnPosition : this.startingColumnPosition;
        int rowIndex = 0;
        while (rowIndex < this.rowPositions.length) {
            int startingRowPosition = this.rowPositions[rowIndex];
            if (this.searchDirection.equals((Object)SearchDirection.SEARCH_BACKWARDS)) {
                cellsToSearch.addAll(CellDisplayValueSearchUtil.getDescendingCellCoordinatesRowFirst(this.getContextLayer(), columnPosition, startingRowPosition, width, 1));
                columnPosition = columnCount - 1;
            } else {
                cellsToSearch.addAll(CellDisplayValueSearchUtil.getCellCoordinatesRowFirst(this.getContextLayer(), columnPosition, startingRowPosition, width, 1));
                columnPosition = 0;
            }
            width = columnCount;
            ++rowIndex;
        }
        return cellsToSearch.toArray(new PositionCoordinate[0]);
    }
}

