/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;

class InlinesSubstitution {
    private final Inline first;
    private final Inline last;
    private final List<Inline> substitution;

    public InlinesSubstitution(Inline first, Inline last, List<Inline> substitution) {
        this.first = Objects.requireNonNull(first);
        this.last = Objects.requireNonNull(last);
        this.substitution = List.copyOf(substitution);
    }

    public List<Inline> apply(List<Inline> inlines) {
        ArrayList<Inline> builder = new ArrayList<Inline>();
        boolean inReplacementSegment = false;
        for (Inline inline : inlines) {
            if (inline == this.first) {
                inReplacementSegment = true;
                builder.addAll(this.substitution);
            }
            if (!inReplacementSegment) {
                builder.add(inline);
            }
            if (!inReplacementSegment || inline != this.last) continue;
            inReplacementSegment = false;
        }
        return List.copyOf(builder);
    }
}

