/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.mylyn.wikitext.commonmark.internal.SimpleLocator;
import org.eclipse.mylyn.wikitext.commonmark.internal.ToStringHelper;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.mylyn.wikitext.util.Preconditions;
import org.eclipse.mylyn.wikitext.util.Strings;
import org.eclipse.mylyn.wikitext.util.WikiToStringStyle;

public class Line {
    private final String text;
    private final int offset;
    private final int lineNumber;

    public Line(int lineNumber, int offset, String text) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String[])new String[0]);
        Preconditions.checkArgument((lineNumber >= 0 ? 1 : 0) != 0, (String[])new String[0]);
        this.lineNumber = lineNumber;
        this.offset = offset;
        this.text = Objects.requireNonNull(text);
    }

    public boolean isEmpty() {
        return Strings.isBlank((String)this.text);
    }

    public String getText() {
        return this.text;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Line segment(int offset, int length) {
        return new Line(this.lineNumber, this.offset + offset, this.text.substring(offset, offset + length));
    }

    public Locator toLocator() {
        return new SimpleLocator(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)WikiToStringStyle.WIKI_TO_STRING_STYLE).append("lineNumber", this.lineNumber).append("offset", this.offset).append("text", (Object)ToStringHelper.toStringValue(this.text)).toString();
    }
}

