/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui.editor;

import junit.framework.TestCase;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class EditorUtilTest
extends TestCase {
    public void testSetEnabledState() {
        Shell shell = new Shell();
        Composite composite = new Composite((Composite)shell, 0);
        Label label = new Label(composite, 0);
        CommonUiUtil.setEnabled((Composite)composite, (boolean)false);
        EditorUtilTest.assertFalse((boolean)composite.getEnabled());
        EditorUtilTest.assertFalse((boolean)label.getEnabled());
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        EditorUtilTest.assertTrue((boolean)composite.getEnabled());
        EditorUtilTest.assertTrue((boolean)label.getEnabled());
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        EditorUtilTest.assertTrue((boolean)composite.getEnabled());
        EditorUtilTest.assertTrue((boolean)label.getEnabled());
    }

    public void testSetEnabledStateDisabledChild() {
        Shell shell = new Shell();
        Composite composite = new Composite((Composite)shell, 0);
        Label label = new Label(composite, 0);
        label.setEnabled(false);
        CommonUiUtil.setEnabled((Composite)composite, (boolean)false);
        EditorUtilTest.assertFalse((boolean)composite.getEnabled());
        EditorUtilTest.assertFalse((boolean)label.getEnabled());
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        EditorUtilTest.assertTrue((boolean)composite.getEnabled());
        EditorUtilTest.assertFalse((boolean)label.getEnabled());
    }

    public void testSetEnabledStateDisabledParent() {
        Shell shell = new Shell();
        Composite composite = new Composite((Composite)shell, 0);
        composite.setEnabled(false);
        Label label = new Label(composite, 0);
        CommonUiUtil.setEnabled((Composite)composite, (boolean)false);
        EditorUtilTest.assertFalse((boolean)composite.getEnabled());
        EditorUtilTest.assertFalse((boolean)label.getEnabled());
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        EditorUtilTest.assertFalse((boolean)composite.getEnabled());
        EditorUtilTest.assertTrue((boolean)label.getEnabled());
    }

    public void testSetEnabledStateDisabledChildAndComposite() {
        Shell shell = new Shell();
        Composite composite = new Composite((Composite)shell, 0);
        composite.setEnabled(false);
        Label label = new Label(composite, 0);
        label.setEnabled(false);
        CommonUiUtil.setEnabled((Composite)composite, (boolean)false);
        EditorUtilTest.assertFalse((boolean)composite.getEnabled());
        EditorUtilTest.assertFalse((boolean)label.getEnabled());
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        EditorUtilTest.assertFalse((boolean)composite.getEnabled());
        EditorUtilTest.assertFalse((boolean)label.getEnabled());
    }

    public void testSetEnabledStateDisableStateRemoved() {
        Shell shell = new Shell();
        Composite composite = new Composite((Composite)shell, 0);
        Label label = new Label(composite, 0);
        label.setEnabled(false);
        CommonUiUtil.setEnabled((Composite)composite, (boolean)false);
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        EditorUtilTest.assertTrue((boolean)composite.getEnabled());
        EditorUtilTest.assertFalse((boolean)label.getEnabled());
    }

    public void testSetEnabledWithoutDisabling() {
        Shell shell = new Shell();
        Composite composite = new Composite((Composite)shell, 0);
        composite.setEnabled(false);
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        EditorUtilTest.assertFalse((boolean)composite.getEnabled());
        CommonUiUtil.setEnabled((Composite)composite, (boolean)true);
        EditorUtilTest.assertFalse((boolean)composite.getEnabled());
    }

    public void testAddScrollListener() {
        Composite textWidget = new Composite((Composite)WorkbenchUtil.getShell(), 512);
        EditorUtilTest.assertNotNull((Object)textWidget.getVerticalBar());
        EditorUtilTest.assertEquals((int)0, (int)textWidget.getListeners(37).length);
        EditorUtil.addScrollListener((Scrollable)textWidget);
        EditorUtilTest.assertEquals((int)1, (int)textWidget.getListeners(37).length);
        textWidget = new Composite((Composite)WorkbenchUtil.getShell(), 0);
        EditorUtilTest.assertNull((Object)textWidget.getVerticalBar());
        EditorUtilTest.assertEquals((int)0, (int)textWidget.getListeners(37).length);
        EditorUtil.addScrollListener((Scrollable)textWidget);
        EditorUtilTest.assertEquals((int)1, (int)textWidget.getListeners(37).length);
    }
}

