/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.bugs;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.commons.core.operations.NullOperationMonitor;
import org.eclipse.mylyn.internal.tasks.bugs.AttributeTaskMapper;
import org.eclipse.mylyn.internal.tasks.bugs.SupportHandlerManager;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProduct;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProviderManager;
import org.eclipse.mylyn.internal.tasks.bugs.SupportRequest;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ProductStatus;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.bugs.IProduct;
import org.eclipse.mylyn.tasks.bugs.ISupportResponse;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorWithTaskDataHandler;

public class SupportHandlerManagerTest
extends TestCase {
    private TaskRepository mockRepository;
    private MockRepositoryConnectorWithTaskDataHandler mockRepositoryConnector;

    public void setUp() throws Exception {
        super.setUp();
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", false);
        TaskTestUtil.resetTaskListAndRepositories();
        this.mockRepositoryConnector = new MockRepositoryConnectorWithTaskDataHandler();
        TasksUiPlugin.getRepositoryManager().addRepositoryConnector((AbstractRepositoryConnector)this.mockRepositoryConnector);
        this.mockRepository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUiPlugin.getRepositoryManager().addRepository(this.mockRepository);
    }

    public void tearDown() throws Exception {
    }

    public void testSupportHandlerManager() throws CoreException {
        SupportHandlerManager handlerManager = new SupportHandlerManager();
        SupportProviderManager providerManager = new SupportProviderManager();
        SupportProduct product = providerManager.getProduct("org.eclipse.mylyn.tasks.tests.productnormal");
        ProductStatus status = new ProductStatus((IProduct)product);
        SupportRequest request = new SupportRequest(providerManager, (IStatus)status, (IProduct)product);
        handlerManager.preProcess(request);
        SupportHandlerManagerTest.assertTrue((boolean)((AttributeTaskMapper)request.getDefaultContribution()).isMappingComplete());
        NullOperationMonitor monitor = new NullOperationMonitor();
        handlerManager.process(request.getDefaultContribution(), (IProgressMonitor)monitor);
        SupportHandlerManagerTest.assertNotNull((Object)request.getDefaultContribution());
        AttributeTaskMapper mapper = (AttributeTaskMapper)request.getDefaultContribution();
        SupportHandlerManagerTest.assertTrue((!mapper.isHandled() ? 1 : 0) != 0);
        TaskData taskData = null;
        taskData = mapper.createTaskData((IProgressMonitor)monitor);
        SupportHandlerManagerTest.assertNotNull((Object)taskData);
        mapper.setTaskData(taskData);
        handlerManager.postProcess((ISupportResponse)mapper, (IProgressMonitor)monitor);
        TaskAttribute serv = taskData.getRoot().getMappedAttribute("task.common.severity");
        SupportHandlerManagerTest.assertEquals((String)"enhancement", (String)serv.getValue());
    }

    public void testSeverityDefinedInExtensionPoint() throws CoreException {
        SupportHandlerManager handlerManager = new SupportHandlerManager();
        SupportProviderManager providerManager = new SupportProviderManager();
        SupportProduct product = providerManager.getProduct("org.eclipse.mylyn.tasks.tests.productseverity");
        ProductStatus status = new ProductStatus((IProduct)product);
        SupportRequest request = new SupportRequest(providerManager, (IStatus)status, (IProduct)product);
        handlerManager.preProcess(request);
        SupportHandlerManagerTest.assertTrue((boolean)((AttributeTaskMapper)request.getDefaultContribution()).isMappingComplete());
        NullOperationMonitor monitor = new NullOperationMonitor();
        handlerManager.process(request.getDefaultContribution(), (IProgressMonitor)monitor);
        SupportHandlerManagerTest.assertNotNull((Object)request.getDefaultContribution());
        AttributeTaskMapper mapper = (AttributeTaskMapper)request.getDefaultContribution();
        SupportHandlerManagerTest.assertTrue((!mapper.isHandled() ? 1 : 0) != 0);
        TaskData taskData = null;
        taskData = mapper.createTaskData((IProgressMonitor)monitor);
        SupportHandlerManagerTest.assertNotNull((Object)taskData);
        mapper.setTaskData(taskData);
        handlerManager.postProcess((ISupportResponse)mapper, (IProgressMonitor)monitor);
        TaskAttribute serv = taskData.getRoot().getAttribute("task.common.severity");
        SupportHandlerManagerTest.assertEquals((String)"blocker", (String)serv.getValue());
    }
}

