/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;

public class TaskListSaveManagerTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRemovalOfSnapshots() throws IOException {
        String backupPath = TasksUiPlugin.getDefault().getBackupFolderPath();
        File backupFolder = new File(backupPath);
        if (!backupFolder.exists()) {
            backupFolder.mkdir();
        }
        Calendar time = TaskActivityUtil.getCalendar();
        File thisHour = this.createFile(backupFolder, time);
        time.add(14, -1000);
        File thisHourEarlier = this.createFile(backupFolder, time);
        TaskActivityUtil.snapStartOfHour((Calendar)time);
        time.add(11, -1);
        time.add(14, -3000);
        File previousHour = this.createFile(backupFolder, time);
        time.add(14, -3000);
        File previousHour2 = this.createFile(backupFolder, time);
        time.add(6, -1);
        File previousDay = this.createFile(backupFolder, time);
        time.add(11, -1);
        File previousDay2 = this.createFile(backupFolder, time);
        time.add(6, -3);
        File previousDay3 = this.createFile(backupFolder, time);
        time.add(11, -1);
        File previousDay4 = this.createFile(backupFolder, time);
        time.add(14, -4000);
        File previousDay5 = this.createFile(backupFolder, time);
        TasksUiPlugin.getBackupManager().removeOldBackups();
        TaskListSaveManagerTest.assertTrue((boolean)thisHour.exists());
        TaskListSaveManagerTest.assertFalse((boolean)thisHourEarlier.exists());
        TaskListSaveManagerTest.assertTrue((boolean)previousHour.exists());
        TaskListSaveManagerTest.assertFalse((boolean)previousHour2.exists());
        TaskListSaveManagerTest.assertTrue((boolean)previousDay.exists());
        TaskListSaveManagerTest.assertFalse((boolean)previousDay2.exists());
        TaskListSaveManagerTest.assertTrue((boolean)previousDay3.exists());
        TaskListSaveManagerTest.assertFalse((boolean)previousDay4.exists());
        TaskListSaveManagerTest.assertFalse((boolean)previousDay5.exists());
    }

    public void testAddTaskDuringSave() {
    }

    private File createFile(File backupFolder, Calendar time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HHmmss", Locale.ENGLISH);
        File newFile = new File(backupFolder, "tasklist-" + format.format(time.getTime()) + ".xml.zip");
        try {
            newFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newFile;
    }
}

