/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;

public class TaskListBackupManagerTest
extends TestCase {
    private AbstractTask task1;
    private TaskListBackupManager backupManager;

    protected void setUp() throws Exception {
        this.backupManager = TasksUiPlugin.getBackupManager();
        CommonTestUtil.deleteFolder((File)new File(TasksUiPlugin.getDefault().getBackupFolderPath()));
        TaskTestUtil.resetTaskList();
    }

    public void testAutoBackupDisabled() throws Exception {
        this.backupManager.start(5L);
        Thread.sleep(3000L);
        TaskListBackupManagerTest.assertEquals((int)0, (int)this.backupManager.getBackupFiles().size());
        this.task1 = new LocalTask("handle", "label");
        TasksUiPlugin.getTaskList().addTask((ITask)this.task1);
        this.backupManager.stop();
        this.backupManager.start(5L);
        Thread.sleep(3000L);
        TaskListBackupManagerTest.assertEquals((int)1, (int)this.backupManager.getBackupFiles().size());
    }

    public void testAutoBackupEnabled() throws Exception {
        this.task1 = new LocalTask("handle", "label");
        TasksUiPlugin.getTaskList().addTask((ITask)this.task1);
        this.backupManager.backupNow(true, null);
        TaskListBackupManagerTest.assertEquals((int)1, (int)this.backupManager.getBackupFiles().size());
        Thread.sleep(1000L);
        this.backupManager.backupNow(true, null);
        TaskListBackupManagerTest.assertEquals((int)2, (int)this.backupManager.getBackupFiles().size());
        TasksUiPlugin.getBackupManager().removeOldBackups();
        TaskListBackupManagerTest.assertEquals((int)1, (int)this.backupManager.getBackupFiles().size());
    }
}

