/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.mylyn.internal.tasks.ui.OptionsProposalProvider;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.junit.Test;

public class OptionsProposalProviderTest
extends TestCase {
    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
    }

    @Test
    public void testEmptyProposals() {
        OptionsProposalProvider provider = new OptionsProposalProvider(new HashMap(), true);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("", 0).length);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("", 10).length);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("test", 0).length);
    }

    @Test
    public void testSingleProposal() {
        Map<String, String> proposalMap = Map.of("aTest", "1");
        OptionsProposalProvider provider = new OptionsProposalProvider(proposalMap, true);
        List<IContentProposal> proposals = Arrays.asList(provider.getProposals("", 0));
        OptionsProposalProviderTest.assertEquals((int)1, (int)proposals.size());
        this.assertProposal("aTest", "aTest", proposals.get(0));
    }

    @Test
    public void testMultipleProposals() {
        Map<String, String> proposalMap = Map.of("aTest", "1", "bTest", "2", "cTest", "3");
        OptionsProposalProvider provider = new OptionsProposalProvider(proposalMap, true);
        List<IContentProposal> proposals = Arrays.asList(provider.getProposals("", 0));
        OptionsProposalProviderTest.assertEquals((int)3, (int)proposals.size());
        this.assertProposal("aTest", "aTest", proposals.get(0));
        this.assertProposal("bTest", "bTest", proposals.get(1));
        this.assertProposal("cTest", "cTest", proposals.get(2));
    }

    @Test
    public void testMultipleProposalsSorted() {
        Map<String, String> proposalMap = Map.of("oneTest", "1", "twoTest", "2", "threeTest", "3");
        OptionsProposalProvider provider = new OptionsProposalProvider(proposalMap, true);
        List<IContentProposal> proposals = Arrays.asList(provider.getProposals("", 0));
        OptionsProposalProviderTest.assertEquals((int)3, (int)proposals.size());
        this.assertProposal("oneTest", "oneTest", proposals.get(0));
        this.assertProposal("threeTest", "threeTest", proposals.get(1));
        this.assertProposal("twoTest", "twoTest", proposals.get(2));
    }

    @Test
    public void testProposalFilterMultiSelect() {
        Map<String, String> proposalMap = Map.of("OneTest", "1", "TwoTest", "2", "ThreeTest", "3");
        OptionsProposalProvider provider = new OptionsProposalProvider(proposalMap, true);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("ThreeTest", 0).length);
        List<IContentProposal> proposals = Arrays.asList(provider.getProposals("ThreeTest,", 0));
        OptionsProposalProviderTest.assertEquals((int)2, (int)proposals.size());
        this.assertProposal("ThreeTest,OneTest", "OneTest", proposals.get(0));
        this.assertProposal("ThreeTest,TwoTest", "TwoTest", proposals.get(1));
        proposals = Arrays.asList(provider.getProposals("ThreeTest, ", 0));
        OptionsProposalProviderTest.assertEquals((int)2, (int)proposals.size());
        this.assertProposal("ThreeTest, OneTest", "OneTest", proposals.get(0));
        this.assertProposal("ThreeTest, TwoTest", "TwoTest", proposals.get(1));
        proposals = Arrays.asList(provider.getProposals("o", 0));
        OptionsProposalProviderTest.assertEquals((int)2, (int)proposals.size());
        this.assertProposal("OneTest", "OneTest", proposals.get(0));
        this.assertProposal("TwoTest", "TwoTest", proposals.get(1));
        proposals = Arrays.asList(provider.getProposals("O", 0));
        OptionsProposalProviderTest.assertEquals((int)2, (int)proposals.size());
        this.assertProposal("OneTest", "OneTest", proposals.get(0));
        this.assertProposal("TwoTest", "TwoTest", proposals.get(1));
        proposals = Arrays.asList(provider.getProposals("one", 0));
        OptionsProposalProviderTest.assertEquals((int)1, (int)proposals.size());
        this.assertProposal("OneTest", "OneTest", proposals.get(0));
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("four", 0).length);
        proposals = Arrays.asList(provider.getProposals("four,", 0));
        OptionsProposalProviderTest.assertEquals((int)3, (int)proposals.size());
        this.assertProposal("four,OneTest", "OneTest", proposals.get(0));
        this.assertProposal("four,ThreeTest", "ThreeTest", proposals.get(1));
        this.assertProposal("four,TwoTest", "TwoTest", proposals.get(2));
        proposals = Arrays.asList(provider.getProposals("four,   ", 0));
        OptionsProposalProviderTest.assertEquals((int)3, (int)proposals.size());
        this.assertProposal("four,   OneTest", "OneTest", proposals.get(0));
        this.assertProposal("four,   ThreeTest", "ThreeTest", proposals.get(1));
        this.assertProposal("four,   TwoTest", "TwoTest", proposals.get(2));
        proposals = Arrays.asList(provider.getProposals(",,           ,four,        five     ,   ", 0));
        OptionsProposalProviderTest.assertEquals((int)3, (int)proposals.size());
        this.assertProposal(",,           ,four,        five     ,   OneTest", "OneTest", proposals.get(0));
        this.assertProposal(",,           ,four,        five     ,   ThreeTest", "ThreeTest", proposals.get(1));
        this.assertProposal(",,           ,four,        five     ,   TwoTest", "TwoTest", proposals.get(2));
        proposals = Arrays.asList(provider.getProposals(",,           ,four,        five     ,   one", 0));
        OptionsProposalProviderTest.assertEquals((int)1, (int)proposals.size());
        this.assertProposal(",,           ,four,        five     ,   OneTest", "OneTest", proposals.get(0));
    }

    @Test
    public void testProposalFilterSingleSelect() {
        Map<String, String> proposalMap = Map.of("OneTest", "1", "TwoTest", "2", "ThreeTest", "3");
        OptionsProposalProvider provider = new OptionsProposalProvider(proposalMap, false);
        List<IContentProposal> proposals = Arrays.asList(provider.getProposals("ThreeTest", 0));
        OptionsProposalProviderTest.assertEquals((int)1, (int)proposals.size());
        this.assertProposal("ThreeTest", "ThreeTest", proposals.get(0));
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("ThreeTest,", 0).length);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("ThreeTest, ", 0).length);
        proposals = Arrays.asList(provider.getProposals("o", 0));
        OptionsProposalProviderTest.assertEquals((int)2, (int)proposals.size());
        this.assertProposal("OneTest", "OneTest", proposals.get(0));
        this.assertProposal("TwoTest", "TwoTest", proposals.get(1));
        proposals = Arrays.asList(provider.getProposals("O", 0));
        OptionsProposalProviderTest.assertEquals((int)2, (int)proposals.size());
        this.assertProposal("OneTest", "OneTest", proposals.get(0));
        this.assertProposal("TwoTest", "TwoTest", proposals.get(1));
        proposals = Arrays.asList(provider.getProposals("one", 0));
        OptionsProposalProviderTest.assertEquals((int)1, (int)proposals.size());
        this.assertProposal("OneTest", "OneTest", proposals.get(0));
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("four", 0).length);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("four,", 0).length);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals("four,   ", 0).length);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals(",,           ,four,        five     ,   ", 0).length);
        OptionsProposalProviderTest.assertEquals((int)0, (int)provider.getProposals(",,           ,four,        five     ,   one", 0).length);
    }

    private void assertProposal(String content, String label, IContentProposal proposal) {
        OptionsProposalProviderTest.assertEquals((String)content, (String)proposal.getContent());
        OptionsProposalProviderTest.assertEquals((String)label, (String)proposal.getLabel());
        OptionsProposalProviderTest.assertNull((Object)proposal.getDescription());
    }
}

