/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util.junit5.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class SuiteFailureSummaryListener
implements TestExecutionListener {
    private final SummaryGeneratingListener delegate = new SummaryGeneratingListener();
    private final Map<TestIdentifier, String> skippedTests = new HashMap<TestIdentifier, String>();

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.delegate.testPlanExecutionStarted(testPlan);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.delegate.executionStarted(testIdentifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Throwable cause;
        this.delegate.executionFinished(testIdentifier, testExecutionResult);
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED && (cause = (Throwable)testExecutionResult.getThrowable().orElse(null)) != null) {
            this.skippedTests.put(testIdentifier, cause.getMessage());
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.delegate.executionSkipped(testIdentifier, reason);
        this.skippedTests.put(testIdentifier, reason);
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.delegate.testPlanExecutionFinished(testPlan);
        TestExecutionSummary summary = this.delegate.getSummary();
        List failures = summary.getFailures();
        if (!failures.isEmpty() || !this.skippedTests.isEmpty()) {
            TestIdentifier id;
            System.err.println("\n=== Non-successful tests summary ===\n");
            String bodyBreak = "";
            if (!failures.isEmpty()) {
                System.err.println("-- Failed Tests --");
                for (TestExecutionSummary.Failure failure : failures) {
                    id = failure.getTestIdentifier();
                    this.printTestDetail(id, failure.getException().toString());
                    bodyBreak = "\n";
                }
            }
            if (!this.skippedTests.isEmpty()) {
                System.err.println(bodyBreak + "-- 'Skipped' Tests --");
                for (Map.Entry entry : this.skippedTests.entrySet()) {
                    id = (TestIdentifier)entry.getKey();
                    this.printTestDetail(id, (String)entry.getValue());
                }
            }
            System.err.println("===========================\n");
        }
    }

    private void printTestDetail(TestIdentifier id, String reason) {
        String className = null;
        String methodName = id.getDisplayName();
        if (id.getSource().isPresent()) {
            Object source = id.getSource().get();
            if (source instanceof MethodSource) {
                MethodSource ms = (MethodSource)source;
                className = ms.getJavaClass().getSimpleName();
                methodName = ms.getMethodName();
            } else if (source instanceof ClassSource) {
                ClassSource cs = (ClassSource)source;
                className = cs.getJavaClass().getSimpleName();
            }
        }
        System.err.println(SuiteFailureSummaryListener.testDetail(className, methodName, reason));
    }

    private static String testDetail(String className, String methodName, String reson) {
        return (String)(className != null ? className + "." : "") + methodName + (String)(reson != null ? ": " + reson : "");
    }
}

