/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.listfilter;

import java.util.ArrayList;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.listfilter.MetadataListFilter;

public class CompositeMetadataListFilter
extends MetadataListFilter {
    private List<MetadataListFilter> filters;

    public CompositeMetadataListFilter() {
        this.filters = new ArrayList<MetadataListFilter>();
    }

    public CompositeMetadataListFilter(List<MetadataListFilter> filters) {
        this.filters = filters;
    }

    public void setFilters(List<MetadataListFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
    }

    public List<MetadataListFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<Metadata> filter(List<Metadata> metadataList) throws TikaException {
        for (MetadataListFilter filter : this.filters) {
            metadataList = filter.filter(metadataList);
        }
        return metadataList;
    }

    public String toString() {
        return "CompositeMetadataListFilter{filters=" + String.valueOf(this.filters) + "}";
    }
}

