/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.gitlab.core.GitlabConfiguration;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRepositoryConnector;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskAttributeMapper;
import org.eclipse.mylyn.internal.gitlab.ui.GitlabQuerySchemaPage;
import org.eclipse.mylyn.internal.gitlab.ui.GitlabRepositorySettingsPage;
import org.eclipse.mylyn.internal.gitlab.ui.GitlabSearchQueryPageSchema;
import org.eclipse.mylyn.internal.provisional.tasks.ui.wizards.QueryPageDetails;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;

public class GitlabConnectorUI
extends AbstractRepositoryConnectorUi {
    public String getConnectorKind() {
        return "org.eclipse.mylyn.gitlab";
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository repository) {
        return new GitlabRepositorySettingsPage("New repository", "Enter the HTTPS-URL to your GitLab repository", repository);
    }

    public IWizard getQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(repository);
        GitlabRepositoryConnector connector = (GitlabRepositoryConnector)this.getConnector();
        TaskData taskData = new TaskData((TaskAttributeMapper)new GitlabTaskAttributeMapper(repository), repository.getConnectorKind(), "Query", "Query");
        GitlabSearchQueryPageSchema.getInstance().initialize(taskData);
        try {
            GitlabConfiguration config = connector.getRepositoryConfiguration(repository);
            config.updateQueryOptions(taskData);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        GitlabQuerySchemaPage mp = new GitlabQuerySchemaPage(this.getConnectorKind(), repository, query, GitlabSearchQueryPageSchema.getInstance(), taskData, new QueryPageDetails(true, "", "EnterQueryParameter", "EnterTitleAndURL", "([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]+)", null));
        wizard.addPage((IWizardPage)mp);
        return wizard;
    }

    public IWizard getNewTaskWizard(TaskRepository repository, ITaskMapping selection) {
        return new NewTaskWizard(repository, selection);
    }

    public boolean hasSearchPage() {
        return false;
    }

    public @Nullable String getReplyText(@NonNull TaskRepository taskRepository, @NonNull ITask task, @Nullable ITaskComment taskComment, boolean includeTask) {
        TaskAttribute note_id = taskComment.getTaskAttribute().getAttribute("note_id");
        String note_idValue = note_id != null ? note_id.getValue() : "";
        return MessageFormat.format("( In reply to {0}#note_{1} )\n", taskComment.getTask().getUrl(), note_idValue);
    }
}

