/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.wizards;

import com.google.gerrit.reviewdb.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.ui.wizards.Messages;
import org.eclipse.mylyn.internal.gerrit.ui.wizards.ProjectNameContentProposal;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class ProjectNameContentProposalProvider
implements IContentProposalProvider {
    private final TaskRepository repository;
    private final GerritConnector connector;

    public ProjectNameContentProposalProvider(GerritConnector connector, TaskRepository repository) {
        this.connector = connector;
        this.repository = repository;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String contentsLowerCase = contents.toLowerCase(Locale.ENGLISH);
        ArrayList<ProjectNameContentProposal> proposals = new ArrayList<ProjectNameContentProposal>();
        GerritClient client = this.connector.getClient(this.repository);
        List<Project> projects = this.getProjects(client);
        if (projects != null) {
            for (Project project : projects) {
                String projectName = project.getName();
                if (!projectName.toLowerCase(Locale.ENGLISH).contains(contentsLowerCase)) continue;
                proposals.add(new ProjectNameContentProposal(projectName));
            }
            return proposals.toArray(new IContentProposal[proposals.size()]);
        }
        return new IContentProposal[]{new MissingConfigurationContentProposal()};
    }

    private List<Project> getProjects(GerritClient client) {
        GerritConfiguration config = client.getConfiguration();
        if (config != null) {
            return config.getProjects();
        }
        return null;
    }

    private static class MissingConfigurationContentProposal
    implements IContentProposal {
        private MissingConfigurationContentProposal() {
        }

        public String getContent() {
            return "";
        }

        public int getCursorPosition() {
            return 0;
        }

        public String getLabel() {
            return Messages.ProjectNameContentProposalProvider_Repository_configuration_needs_to_be_refreshed;
        }

        public String getDescription() {
            return null;
        }
    }
}

